<?php $__env->startSection('pagename'); ?>
 - <?php echo e(__('Career')); ?> - <?php echo e(convertUtf8($job->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$job->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$job->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', __('Job Details')); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($job->title)); ?>
<?php $__env->startSection('breadcrumb-link', __('Job Details')); ?>

<?php $__env->startSection('content'); ?>

  <!--    job details section start   -->
  <div class="service-details-section pt-115 pb-115">
     <div class="container">
        <div class="row">
           <div class="col-lg-7">
              <div class="job-details">
                <h3><?php echo e(convertUtf8($job->title)); ?></h3>
                <?php if(!empty($job->vacancy)): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Vacancy')); ?></strong>
                    <div class="desc"><?php echo e(convertUtf8($job->vacancy)); ?></div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->job_responsibilities))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Job Responsibilities')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->job_responsibilities)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->employment_status))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Employment Status')); ?></strong>
                    <div class="desc"><?php echo e(convertUtf8($job->employment_status)); ?></div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->educational_requirements))): ?>
                <div class="info">
                    <strong class="label">Educational Requirements</strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->educational_requirements)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->experience_requirements))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Experience Requirements')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->experience_requirements)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->additional_requirements))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Additional Requirements')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->additional_requirements)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->job_location))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Job Location')); ?></strong>
                    <div class="desc">
                        <?php echo e(convertUtf8($job->job_location)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->salary))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Salary')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->salary)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->benefits))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Compensation & Other Benefits')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->benefits)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->read_before_apply))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Read Before Apply')); ?></strong>
                    <div class="desc">
                        <?php echo replaceBaseUrl(convertUtf8($job->read_before_apply)); ?>

                    </div>
                </div>
                <?php endif; ?>
                <?php if(!empty(convertUtf8($job->email))): ?>
                <div class="info">
                    <strong class="label"><?php echo e(__('Email')); ?></strong>
                    <div class="desc">
                        <?php echo e(__('Send your CV to')); ?> <strong class="text-danger"><?php echo e(convertUtf8($job->email)); ?></strong>.
                    </div>
                </div>
                <?php endif; ?>
              </div>
           </div>
           <!--    career sidebar start   -->
           <div class="col-lg-4">
             <div class="blog-sidebar-widgets">
                <div class="searchbar-form-section">
                   <form action="<?php echo e(route('front.career')); ?>">
                      <div class="searchbar">
                         <input name="category" type="hidden" value="<?php echo e(request()->input('category')); ?>">
                         <input name="term" type="text" placeholder="<?php echo e(__('Search Jobs')); ?>" value="<?php echo e(request()->input('term')); ?>">
                         <button type="submit"><i class="fa fa-search"></i></button>
                      </div>
                   </form>
                </div>
             </div>
             <div class="blog-sidebar-widgets category-widget">
                <div class="category-lists job">
                   <h4><?php echo e(__('Job Categories')); ?></h4>
                   <ul>
                      <li class="single-category">
                          <a href="<?php echo e(route('front.career')); ?>"><?php echo e(__('All')); ?> <span>(<?php echo e($jobscount); ?>)</span></a>
                      </li>
                      <?php $__currentLoopData = $jcats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $jcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="single-category <?php echo e($job->jcategory->id == $jcat->id ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('front.career', ['category' => $jcat->id, 'term'=>request()->input('term')])); ?>"><?php echo e(convertUtf8($jcat->name)); ?> <span>(<?php echo e($jcat->jobs()->count()); ?>)</span></a>
                        </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </ul>
                </div>
             </div>
             <div class="subscribe-section">
                <span><?php echo e(__('SUBSCRIBE')); ?></span>
                <h3><?php echo e(__('SUBSCRIBE FOR NEWSLETTER')); ?></h3>
                <form id="subscribeForm" class="subscribe-form" action="<?php echo e(route('front.subscribe')); ?>" method="POST">
                   <?php echo csrf_field(); ?>
                   <div class="form-element"><input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>"></div>
                   <p id="erremail" class="text-danger mb-3 err-email"></p>
                   <div class="form-element"><input type="submit" value="<?php echo e(__('Subscribe')); ?>"></div>
                </form>
             </div>
           </div>
           <!--    service sidebar end   -->
        </div>
     </div>
  </div>
  <!--    job details section end   -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/career-details.blade.php ENDPATH**/ ?>