<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('Course')); ?> - <?php echo e(convertUtf8($course_details->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/magnific-popup.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/nice-select.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', $bex->course_details_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $course_details->title); ?>
<?php $__env->startSection('breadcrumb-link', $course_details->title); ?>

<?php $__env->startSection('content'); ?>
  
  <section class="course-details-section pt-120 pb-120">
    <div class="container">
      <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="alert alert-danger alert-block">
            <strong><?php echo e($error); ?></strong>
            <button type="button" class="close" data-dismiss="alert">×</button>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
      <div class="row">
        <div class="col-lg-6">
          <div class="courses-img-box">
            <img data-src="<?php echo e(asset('assets/front/img/courses/' . $course_details->course_image)); ?>"
              class="lazy img-fluid" alt="">
            <div class="video-box">
              <a href="<?php echo e($course_details->video_link); ?>" class="video-popup"><i class="fas fa-play"></i></a>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="course-content">
            <h3><?php echo e(convertUtf8($course_details->title)); ?></h3>


            <?php if($bex->is_course_rating == 1): ?>
              <div class="rate mb-3 mt-3">
                <div class="rating" style="width: <?php echo e($course_details->review()->avg('rating') * 20); ?>%"></div>
              </div>
            <?php endif; ?>


            <p class="price">
              <?php if(empty($course_details->current_price)): ?>
                <span class="off-price"><?php echo e(__('Free')); ?></span>
              <?php else: ?>
                <span
                  class="off-price"><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?>

                  <?php echo e($course_details->current_price); ?>

                  <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></span>
                <?php if(!empty($course_details->previous_price)): ?>
                  <span
                    class="main-price"><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?>

                    <?php echo e($course_details->previous_price); ?>

                    <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></span>
                <?php endif; ?>
              <?php endif; ?>
            </p>
            <p><?php echo e($course_details->summary); ?></p>
            <ul class="info">
              <li><?php echo e(__('Category') . ':'); ?><span><a
                    href="<?php echo e(route('courses', ['categroy_id' => $course_details->course_category_id])); ?>"><?php echo e($course_details->courseCategory->name); ?></a></span>
              </li>
            </ul>
            <form method="POST" id="paymentGatewayForm" enctype="multipart/form-data">
              
              <?php echo csrf_field(); ?>
              <input type="hidden" name="course_id" value="<?php echo e($course_details->id); ?>">
              <div class="d-flex flex-row">


                <?php if(auth()->guard()->check()): ?>
                  <?php
                    $pcourse = Auth::user()
                        ->courseOrder()
                        ->where('course_id', $course_details->id)
                        ->where('payment_status', 'completed');
                  ?>
                  <?php if(Auth::check() && $pcourse->count() > 0): ?>
                    <strong class="text-danger mb-3 mr-4"><?php echo e(__('Already Purchased')); ?></strong><br>
                    <a class="text-primary"
                      href="<?php echo e(route('user.course.lessons', $pcourse->first()->id)); ?>"><?php echo e(__('Go to this Course')); ?></a>
                  <?php else: ?>
                    <div
                      class="form_group <?php echo e($rtl == 1 ? 'ml-3' : 'mr-3'); ?> <?php echo e($course_details->current_price == null ? 'd-none' : ''); ?>">
                      <select name="gateway" id="paymentType" class="select-payment">
                        <option selected disabled><?php echo e(__('Pay Via')); ?></option>
                        <?php $__currentLoopData = $paymentGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($paymentGateway->keyword); ?>"><?php echo e($paymentGateway->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $offlineGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offlineGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($offlineGateway->id); ?>" data-type="offline"><?php echo e($offlineGateway->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                    <div class="form-group button mb-20">
                      <button type="submit" id="enrollBtn"
                        class="main-btn <?php echo e($course_details->current_price == null ? 'd-none' : ''); ?>"><?php echo e(__('Enroll Now')); ?></button>
                    </div>
                    <div class="form-group button mb-20">
                      <button type="submit" id="enrollBtn__free"
                        class="main-btn <?php echo e($course_details->current_price != null ? 'd-none' : ''); ?>"><?php echo e(__('Enroll Now')); ?></button>
                    </div>
                  <?php endif; ?>
                <?php endif; ?>
                <?php if(auth()->guard()->guest()): ?>
                  <div
                    class="form_group <?php echo e($rtl == 1 ? 'ml-3' : 'mr-3'); ?> <?php echo e($course_details->current_price == null ? 'd-none' : ''); ?>">
                    <select name="gateway" id="paymentType" class="select-payment">
                      <option selected disabled><?php echo e(__('Pay Via')); ?></option>
                      <?php $__currentLoopData = $paymentGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($paymentGateway->keyword); ?>"><?php echo e($paymentGateway->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php $__currentLoopData = $offlineGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offlineGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($offlineGateway->id); ?>" data-type="offline"><?php echo e($offlineGateway->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                  <div class="form-group button mb-20">
                    <button type="submit" id="enrollBtn"
                      class="main-btn <?php echo e($course_details->current_price == null ? 'd-none' : ''); ?>"><?php echo e(__('Enroll Now')); ?></button>
                  </div>
                  <div class="form-group button mb-20">
                    <button type="submit" id="enrollBtn__free"
                      class="main-btn <?php echo e($course_details->current_price != null ? 'd-none' : ''); ?>"><?php echo e(__('Enroll Now')); ?></button>
                  </div>
                <?php endif; ?>
              </div>
              <div class="row mt-3 d-none" id="stripeTab">
                <div class="col-md-12 mb-3">
                  <div id="stripe-element">
                    <!-- A Stripe Element will be inserted here. -->
                  </div>
                  <!-- Used to display form errors -->
                  <div id="stripe-errors" class="pb-2 text-danger text-left" role="alert"></div>
                </div>
              </div>

              <div class="row mt-3 d-none" id="payumoneyTab">
                <div class="col-md-6 mb-3">
                  <div class="field-label mb-2"><?php echo e(__('First Name')); ?>*</div>
                  <div class="field-input mb-2">
                    <input type="text" name="payumoney_first_name" placeholder="<?php echo e(__('Enter First Name')); ?>" />
                  </div>
                  <?php if($errors->has('payumoney_first_name')): ?>
                    <p class="mb-0 text-danger"><?php echo e($errors->first('payumoney_first_name')); ?></p>
                  <?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <div class="field-label mb-2"><?php echo e(__('Last Name')); ?>*</div>
                  <div class="field-input mb-2">
                    <input type="text" name="payumoney_last_name" placeholder="<?php echo e(__('Enter Last Name')); ?>" />
                  </div>
                  <?php if($errors->has('payumoney_last_name')): ?>
                    <p class="mb-0 text-danger"><?php echo e($errors->first('payumoney_last_name')); ?></p>
                  <?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <div class="field-label mb-2"><?php echo e(__('Phone Number')); ?>*</div>
                  <div class="field-input mb-2">
                    <input type="text" name="payumoney_phone" placeholder="<?php echo e(__('Enter Phone Number')); ?>" />
                  </div>
                  <?php if($errors->has('payumoney_phone')): ?>
                    <p class="mb-0 text-danger"><?php echo e($errors->first('payumoney_phone')); ?></p>
                  <?php endif; ?>
                </div>
              </div>



              <?php $__currentLoopData = $offlineGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ogateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="gateway-details row" id="tab-<?php echo e($ogateway->id); ?>" style="display: none;">
                  <div class="col-12">
                    <p class="gateway-desc"><?php echo e($ogateway->short_description); ?></p>
                  </div>
                  <div class="col-12">
                    <div class="gateway-instruction">
                      <?php echo replaceBaseUrl($ogateway->instructions); ?>

                    </div>
                  </div>

                  <?php if($ogateway->is_receipt == 1): ?>
                    <div class="col-12 mb-4">
                      <label for="" class="d-block"><?php echo e(__('Receipt')); ?> **</label>
                      <input type="file" name="receipt">
                      <p class="mb-0 text-warning">** <?php echo e(__('Receipt image must be .jpg / .jpeg / .png')); ?></p>
                    </div>
                  <?php endif; ?>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              <p class="text-danger payment-warning" style="display: none;">*Please select a payment method</p>
            </form>
            <ul class="social-link">
              <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
              <li><a href="#"><i class="fab fa-twitter"></i></a></li>
              <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
              <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
            </ul>
          </div>
        </div>
      </div>
      <div class="row mt-80">
        <div class="col-lg-12">
          <div class="discription-area">
            <div class="discription-tabs">
              <ul class="nav nav-tabs">
                <li class="nav-item">
                  <a class="nav-link active" data-toggle="tab" href="#overview"><?php echo e(__('Overview')); ?></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#outline"><?php echo e(__('Outline')); ?></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#instructor"><?php echo e(__('Instructor')); ?></a>
                </li>

                <?php if($bex->is_course_rating == 1): ?>
                  <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#reviews"><?php echo e(__('Reviews')); ?></a>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
            <div class="tab-content">
              <div id="overview" class="tab-pane active">
                <div class="content-box">
                  <h4><?php echo e(__('Overview')); ?></h4>
                  <p><?php echo $course_details->overview; ?></p>
                </div>
              </div>
              <div id="outline" class="tab-pane fade">
                <div class="content-box">
                  <div class="accordion" id="accordionExample">
                    <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="card">
                        <a class="card-header collapsed" href="#" id="headingone" data-toggle="collapse"
                          data-target="<?php echo e('#collapse' . $module->id); ?>"
                          aria-expanded="<?php echo e($loop->first ? 'true' : 'false'); ?>"
                          aria-controls="collapseone"><?php echo e($module->name); ?><span class="toggle_btn"></span>
                        </a>
                        <div id="<?php echo e('collapse' . $module->id); ?>"
                          class="<?php echo e($loop->first ? 'collapse show' : 'collapse'); ?>" aria-labelledby="headingOne"
                          data-parent="#accordionExample" style="">
                          <div class="card-body">
                            <?php
                              $lessons = App\Lesson::where('module_id', $module->id)->get();
                            ?>
                            <ul>
                              <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a><i class="fas fa-play"></i> <?php echo e($lesson->name); ?> <span
                                      class="duration"><?php echo e($lesson->duration); ?></span></a></li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </div>
              <div id="instructor" class="tab-pane fade">
                <div class="instructor-wrap">
                  <div class="thumb">
                    <img data-src="<?php echo e(asset('assets/front/img/instructors/' . $course_details->instructor_image)); ?>"
                      class="img-fluid lazy" alt="">
                  </div>
                  <div class="content">
                    <h4><?php echo e($course_details->instructor_name); ?></h4>
                    <span><?php echo e($course_details->instructor_occupation); ?></span>
                    <div class="text-box">
                      <p><?php echo e($course_details->instructor_details); ?></p>
                    </div>
                    <ul class="social-link">
                      <?php if(!empty($course_details->instructor_facebook)): ?>
                        <li><a href="<?php echo e($course_details->instructor_facebook); ?>" target="_blank"><i
                              class="fab fa-facebook-f"></i></a></li>
                      <?php endif; ?>
                      <?php if(!empty($course_details->instructor_twitter)): ?>
                        <li><a href="<?php echo e($course_details->instructor_twitter); ?>" target="_blank"><i
                              class="fab fa-twitter"></i></a></li>
                      <?php endif; ?>
                      <?php if(!empty($course_details->instructor_instagram)): ?>
                        <li><a href="<?php echo e($course_details->instructor_instagram); ?>" target="_blank"><i
                              class="fab fa-instagram"></i></a></li>
                      <?php endif; ?>
                      <?php if(!empty($course_details->instructor_linkedin)): ?>
                        <li><a href="<?php echo e($course_details->instructor_linkedin); ?>" target="_blank"><i
                              class="fab fa-linkedin-in"></i></a></li>
                      <?php endif; ?>
                    </ul>
                  </div>
                </div>
              </div>

              <?php if($bex->is_course_rating == 1): ?>
                <div id="reviews" class="tab-pane fade">
                  <div class="shop-review-area">
                    <?php $numOfReview = count($reviews); ?>
                    <?php if($numOfReview == 0): ?>
                      <h4 class="title"><?php echo e(__('This course has no review yet')); ?></h4>
                    <?php else: ?>
                      <h4 class="title">
                        <?php echo e($numOfReview == 1 ? '1' . ' ' . __('Review for this course') : $numOfReview . ' ' . __('Reviews for this course')); ?>

                      </h4>
                      <div class="mb-5">
                        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="review_user">
                            <?php if(strpos($review->reviewByUser->photo, 'facebook') !== false || strpos($review->reviewByUser->photo, 'google')): ?>
                              <img class="lazy"
                                data-src="<?php echo e($review->reviewByUser->photo ? $review->reviewByUser->photo : asset('assets/front/img/user/profile.jpg')); ?>"
                                alt="user image">
                            <?php else: ?>
                              <img class="lazy"
                                data-src="<?php echo e($review->reviewByUser->photo ? asset('assets/front/img/user/' . $review->reviewByUser->photo) : ''); ?>"
                                alt="user image">
                            <?php endif; ?>
                            <div class="rate">
                              <div class="rating" style="width: <?php echo e($review->rating * 20); ?>%"></div>
                            </div>
                            <?php if($rtl == 1): ?>
                              <span><span><?php echo e($review->created_at->format('M d, Y')); ?></span>
                                <?php echo e('- ' . $review->reviewByUser->fname . ' ' . $review->reviewByUser->lname); ?></span>
                            <?php else: ?>
                              <span><span><?php echo e($review->reviewByUser->fname . ' ' . $review->reviewByUser->lname); ?></span>
                                <?php echo e('- ' . $review->created_at->format('M d, Y')); ?></span>
                            <?php endif; ?>
                            <p><?php echo e($review->comment); ?></p>
                          </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                    <?php endif; ?>
                    <?php if(Auth::user()): ?>
                      <div class="review_form pt-4">
                        <form action="<?php echo e(route('course.review')); ?>" method="POST">
                          <?php echo csrf_field(); ?>
                          <input type="hidden" name="course_id" value="<?php echo e($course_details->id); ?>">
                          <div class="form_group">
                            <label><?php echo e(__('Comment')); ?></label>
                            <textarea class="form_control mt-2" name="comment" placeholder="<?php echo e(__('Write something about this course')); ?>"></textarea>
                          </div>
                          <input type="hidden" id="ratingId" name="rating">
                          <div class="form_group">
                            <label><?php echo e(__('Rating') . '*'); ?></label>
                            <div class="review-content mt-2">
                              <ul class="review-value review-1">
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="1"><i class="far fa-star"></i></a>
                                </li>
                              </ul>
                              <ul class="review-value review-2">
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="2"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="2"><i class="far fa-star"></i></a>
                                </li>
                              </ul>
                              <ul class="review-value review-3">
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                                </li>
                              </ul>
                              <ul class="review-value review-4">
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                                </li>
                              </ul>
                              <ul class="review-value review-5">
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                                </li>
                                <li>
                                  <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                                </li>
                              </ul>
                            </div>
                          </div>
                          <div class="form_button">
                            <button type="submit" class="main-btn mt-2"><?php echo e(__('Submit')); ?></button>
                          </div>
                        </form>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script src="<?php echo e(asset('assets/front/js/jquery.magnific-popup.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/front/js/jquery.nice-select.min.js')); ?>"></script>
  <script>
    let stripe_key = "<?php echo e($stripe_key); ?>";
  </script>
  <script src="https://js.stripe.com/v3/"></script>
  <script src="<?php echo e(asset('assets/front/js/course-checkout-stripe.js')); ?>"></script>
  <script>
    $(document).ready(function() {
      // Magnific Popup
      $('.video-popup').magnificPopup({
        type: 'iframe',
        removalDelay: 300,
        mainClass: 'mfp-fade'
      });

      // jquery nice select js
      $('select').niceSelect();

      // change form action for various payment gateways
      $(document).on('click', '#enrollBtn', function() {
        let paymentGateway = $('#paymentType').val();
        let type = $('#paymentType').find("option:selected").data('type');
        //    console.log(paymentGateway, type);

        if (paymentGateway == null) {
          event.preventDefault();
          $('.payment-warning').fadeIn().delay(1500).fadeOut();
        }

        if (type == 'offline') {
          $('#paymentGatewayForm').attr('action', "<?php echo e(url('/')); ?>" + "/course/offline/" + paymentGateway +
            "/submit");
        } else {
          if (paymentGateway == 'paypal') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.paypal')); ?>");
          } else if (paymentGateway == 'paytm') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.paytm')); ?>");
          } else if (paymentGateway == 'razorpay') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.razorpay')); ?>");
          } else if (paymentGateway == 'stripe') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.stripe')); ?>");
          } else if (paymentGateway == 'instamojo') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.instamojo')); ?>");
          } else if (paymentGateway == 'mollie') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.mollie')); ?>");
          } else if (paymentGateway == 'flutterwave') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.flutterwave')); ?>");
          } else if (paymentGateway == 'mercadopago') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.mercadopago')); ?>");
          } else if (paymentGateway == 'paystack') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.paystack')); ?>");
          } else if (paymentGateway == 'payumoney') {
            $('#paymentGatewayForm').attr('action', "<?php echo e(route('course.payment.payumoney')); ?>");
          }
        }

      });

      // enroll free course by clicking the 'enroll now' button
      $(document).on('click', '#enrollBtn__free', function() {
        $('#paymentGatewayForm').attr('action', "<?php echo e(route('free_course.enroll')); ?>");
      });

      // show the input form for the stripe payment
      $(document).on('change', '#paymentType', function() {
        let gatewayName = $(this).val();
        let type = $(this).find('option:checked').data('type');

        if (gatewayName == 'stripe') {
          $('#stripeTab').removeClass('d-none');
        } else {
          $('#stripeTab').addClass('d-none');
        }

        if (gatewayName == 'payumoney') {
          $('#payumoneyTab').removeClass('d-none');
          $('#payumoneyTab input').removeAttr('disabled');
        } else {
          $('#payumoneyTab input').attr('disabled', true);
          $('#payumoneyTab').addClass('d-none');
        }

        if (type == 'offline') {
          $(".gateway-details").hide();
          $("#tab-" + gatewayName).show();

          $(".gateway-details").attr('disabled', true);
          $("#tab-" + gatewayName + " input").removeAttr('disabled');
        } else {
          $(".gateway-details").hide();
          $(".gateway-details").attr('disabled', true);
        }
      });

      // get the rating (star) value in integer
      $(document).on('click', '.review-value li a', function() {
        let ratingValue = $(this).attr('data-ratingVal');

        // first, remove star color from all the 'review-value' class
        $('.review-value li a i').removeClass('text-warning');

        // second, add star color to the selected parent class
        let parentClass = `review-${ratingValue}`;
        $('.' + parentClass + ' li a i').addClass('text-warning');

        $('#ratingId').val(ratingValue);
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/course/course_details.blade.php ENDPATH**/ ?>