<?php $__env->startSection('pagename'); ?>
- <?php echo e(__('Contact Us')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->contact_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->contact_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $bs->contact_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $bs->contact_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Contact Us')); ?>

<?php $__env->startSection('content'); ?>


<!--    contact form and map start   -->
<div class="contact-form-section">
    <div class="container">
        <div class="contact-infos mb-5">
            <div class="row no-gutters">
                <div class="col-lg-4 single-info-col">
                    <div class="single-info wow fadeInRight" data-wow-duration="1s" style="visibility: visible; animation-duration: 1s; animation-name: fadeInRight;">
                        <div class="icon-wrapper"><i class="fas fa-home"></i></div>
                        <div class="info-txt">
                            <?php
                                $addresses = explode(PHP_EOL, $bex->contact_addresses);
                            ?>
                            <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><i class="fas fa-map-pin base-color mr-1"></i> <?php echo e($address); ?></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 single-info-col">
                    <div class="single-info wow fadeInRight" data-wow-duration="1s" data-wow-delay=".2s" style="visibility: visible; animation-duration: 1s; animation-delay: 0.2s; animation-name: fadeInRight;">
                        <div class="icon-wrapper"><i class="fas fa-phone"></i></div>
                        <div class="info-txt">
                            <?php
                                $phones = explode(',', $bex->contact_numbers);
                            ?>
                            <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><?php echo e($phone); ?></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 single-info-col">
                    <div class="single-info wow fadeInRight" data-wow-duration="1s" data-wow-delay=".4s" style="visibility: visible; animation-duration: 1s; animation-delay: 0.4s; animation-name: fadeInRight;">
                        <div class="icon-wrapper"><i class="far fa-envelope"></i></div>
                        <div class="info-txt">
                            <?php
                                $mails = explode(',', $bex->contact_mails);
                            ?>
                            <?php $__currentLoopData = $mails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><?php echo e($mail); ?></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <span class="section-title"><?php echo e(convertUtf8($bs->contact_form_title)); ?></span>
                <h2 class="section-summary"><?php echo e(convertUtf8($bs->contact_form_subtitle)); ?></h2>
                <form action="<?php echo e(route('front.sendmail')); ?>" class="contact-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-element">
                                <input name="name" type="text" placeholder="<?php echo e(__('Name')); ?>" required>
                            </div>
                            <?php if($errors->has('name')): ?>
                            <p class="text-danger mb-0"><?php echo e($errors->first('name')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-element">
                                <input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>" required>
                            </div>
                            <?php if($errors->has('email')): ?>
                            <p class="text-danger mb-0"><?php echo e($errors->first('email')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-12">
                            <div class="form-element">
                                <input name="subject" type="text" placeholder="<?php echo e(__('Subject')); ?>" required>
                            </div>
                            <?php if($errors->has('subject')): ?>
                            <p class="text-danger mb-0"><?php echo e($errors->first('subject')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-12">
                            <div class="form-element">
                                <textarea name="message" id="comment" cols="30" rows="10" placeholder="<?php echo e(__('Comment')); ?>" required></textarea>
                            </div>
                            <?php if($errors->has('message')): ?>
                            <p class="text-danger mb-0"><?php echo e($errors->first('message')); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php if($bs->is_recaptcha == 1): ?>
                        <div class="col-lg-12 mb-4">
                            <?php echo NoCaptcha::renderJs(); ?>

                            <?php echo NoCaptcha::display(); ?>

                            <?php if($errors->has('g-recaptcha-response')): ?>
                            <?php
                            $errmsg = $errors->first('g-recaptcha-response');
                            ?>
                            <p class="text-danger mb-0"><?php echo e(__("$errmsg")); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        <div class="col-md-12">
                            <div class="form-element no-margin">
                                <input type="submit" value="<?php echo e(__('Submit')); ?>">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-6">
                <div class="map-wrapper">
                    <div id="map">
                        <iframe width="100%" height="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=<?php echo e($bex->latitude); ?>,%20<?php echo e($bex->longitude); ?>+(My%20Business%20Name)&amp;t=&amp;z=<?php echo e($bex->map_zoom); ?>&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--    contact form and map end   -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/contact.blade.php ENDPATH**/ ?>