<!DOCTYPE html>
<html lang="en" <?php if($rtl == 1): ?> dir="rtl" <?php endif; ?>>

<head>
  <!--Start of Google Analytics script-->
  <?php if($bs->is_analytics == 1): ?>
    <?php echo $bs->google_analytics_script; ?>

  <?php endif; ?>
  <!--End of Google Analytics script-->

  <!--====== Required meta tags ======-->
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
  <meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>">

  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo e($bs->website_title); ?> <?php echo $__env->yieldContent('pagename'); ?></title>
  <!-- favicon -->
  <link rel="shortcut icon" href="<?php echo e(asset('assets/front/img/' . $bs->favicon)); ?>" type="image/x-icon">
  <!-- bootstrap css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
  <!-- plugin css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.min.css')); ?>">
  <!--default css-->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/default.css')); ?>">
  <!-- common css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/common-style.css')); ?>">
  <!-- main css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/ecommerce-style.css')); ?>">
  <!-- responsive css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">
  <!-- ecommerce responsive css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/ecommerce-responsive.css')); ?>">

  <?php if($bs->is_tawkto == 1 || $bex->is_whatsapp == 1): ?>
    <style>
      #scroll_up {
        right: auto;
        left: 20px;
      }
    </style>
  <?php endif; ?>
  <?php if(count($langs) == 0): ?>
    <style media="screen">

    </style>
  <?php endif; ?>

  <!-- common base color change -->
  <link href="<?php echo e(url('/')); ?>/assets/front/css/common-base-color.php?color=<?php echo e($bs->base_color); ?>"
    rel="stylesheet">
  <!-- base color change -->
  <link href="<?php echo e(url('/')); ?>/assets/front/css/ecommerce-base-color.php?color=<?php echo e($bs->base_color); ?>"
    rel="stylesheet">


  <?php if($rtl == 1): ?>
    <!-- RTL css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/ecommerce-rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/pb-rtl.css')); ?>">
  <?php endif; ?>
  <?php echo $__env->yieldContent('styles'); ?>

  <!-- jquery js -->
  <script src="<?php echo e(asset('assets/front/js/jquery-3.3.1.min.js')); ?>"></script>

  <?php if($bs->is_appzi == 1): ?>
    <!-- Start of Appzi Feedback Script -->
    <script async src="https://app.appzi.io/bootstrap/bundle.js?token=<?php echo e($bs->appzi_token); ?>"></script>
    <!-- End of Appzi Feedback Script -->
  <?php endif; ?>

  <!-- Start of Facebook Pixel Code -->
  <?php if($be->is_facebook_pexel == 1): ?>
    <?php echo $be->facebook_pexel_script; ?>

  <?php endif; ?>
  <!-- End of Facebook Pixel Code -->

  <!--Start of Appzi script-->
  <?php if($bs->is_appzi == 1): ?>
    <?php echo $bs->appzi_script; ?>

  <?php endif; ?>
  <!--End of Appzi script-->
</head>

<body>

  <?php if ($__env->exists('front.ecommerce.partials.header')) echo $__env->make('front.ecommerce.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php if(!request()->routeIs('front.index') && !request()->routeIs('front.packageorder.confirmation')): ?>
    <!--   breadcrumb area start   -->
    <div class="breadcrumb-area lazy" data-bg="<?php echo e(asset('assets/front/img/' . $bs->breadcrumb)); ?>"
      style="background-size:cover;">
      <div class="container">
        <div class="breadcrumb-txt">
          <div class="row">
            <div class="col-xl-7 col-lg-8 col-sm-10">
              <span><?php echo $__env->yieldContent('breadcrumb-title'); ?></span>
              <h1><?php echo $__env->yieldContent('breadcrumb-subtitle'); ?></h1>
              <ul class="breadcumb">
                <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(__('Home')); ?></a></li>
                <li><?php echo $__env->yieldContent('breadcrumb-link'); ?></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <div class="breadcrumb-area-overlay"
        style="background-color: #<?php echo e($be->breadcrumb_overlay_color); ?>;opacity: <?php echo e($be->breadcrumb_overlay_opacity); ?>;">
      </div>
    </div>
    <!--   breadcrumb area end    -->
  <?php endif; ?>

  <?php echo $__env->yieldContent('content'); ?>

  <?php if ($__env->exists('front.ecommerce.partials.footer')) echo $__env->make('front.ecommerce.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php if($bex->is_shop == 1 && $bex->catalog_mode == 0): ?>
    <div id="cartIconWrapper">
      <a class="d-block" id="cartIcon" href="<?php echo e(route('front.cart')); ?>">
        <div class="cart-length">
          <i class="fas fa-cart-plus"></i>
          <span class="length"><?php echo e(cartLength()); ?> <?php echo e(__('ITEMS')); ?></span>
        </div>
        <div class="cart-total">
          <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?>

          <?php echo e(cartTotal()); ?>

          <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

        </div>
      </a>
    </div>
  <?php endif; ?>

  <!--====== back-to-top ======-->
  <a href="#" class="back-to-top"><i class="fas fa-angle-up"></i></a>

  <!--====== Start Preloader ======-->
  <?php if($bex->preloader_status == 1): ?>
    <div class="preloader">
      <div class="lds-ellipsis">
        <img src="<?php echo e(asset('assets/front/img/' . $bex->preloader)); ?>" alt="">
      </div>
    </div>
  <?php endif; ?>
  <!--====== End Preloader ======-->

  
  <div id="WAButton"></div>

  
  <?php if($be->cookie_alert_status == 1): ?>
    <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  

  
  <?php if ($__env->exists('front.partials.popups')) echo $__env->make('front.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  

  <?php if ($__env->exists('front.ecommerce.partials.scripts')) echo $__env->make('front.ecommerce.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/ecommerce/layout.blade.php ENDPATH**/ ?>