        <!--====== Start header-area ======-->
        <header class="header-area">
            <div class="header-top">
                <div class="custom-container">
                    <div class="row align-items-center">
                        <div class="col-xl-4 d-xl-block d-none">
                            <div class="top-left">
                                <ul>
                                    <li><a href="tel:<?php echo e($bs->support_phone); ?>"><i class="fas fa-mobile-alt mr-2"></i> <?php echo e($bs->support_phone); ?></a></li>
                                    <li><a href="mailto:<?php echo e($bs->support_email); ?>"><i class="far fa-envelope-open mr-2"></i> <?php echo e($bs->support_email); ?></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <div class="nav-search">
                                <?php
                                    $maxprice = App\Product::max('current_price');
                                    $minprice = 0;
                                ?>
                                <form action="<?php echo e(route('front.product')); ?>">
                                    <div class="form_group">
                                        <input type="text" class="form_control" name="search" placeholder="<?php echo e(__('Search Keywords')); ?>" value="<?php echo e(!empty(request()->input('search')) ? request()->input('search') : ''); ?>">
                                        <i class="fas fa-search"></i>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <div class="top-right">
                                <ul>
                                    <li>
                                        <form id="langForm" class="d-inline-block">
                                            <select name="language" class="form-control form-control-sm mb-0">
                                                <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e($lang->code == $currentLang->code ? 'selected' : ''); ?> value="<?php echo e($lang->code); ?>"><?php echo e($lang->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </form>
                                    </li>
                                    <?php if(auth()->guard()->guest()): ?>
                                        <?php if($bex->is_user_panel == 1): ?>
                                            <li><a href="<?php echo e(route('user.login')); ?>" class="login"><?php echo e(__('Login')); ?><i class="far fa-user"></i></a></li>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if(auth()->guard()->check()): ?>
                                        <?php if($bex->is_user_panel == 1): ?>
                                            <li><a href="<?php echo e(route('user-dashboard')); ?>" class="login"><?php echo e(__('Dashboard')); ?><i class="far fa-user"></i></a></li>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-navigation">
                <div class="custom-container">
                    <div class="nav-container">
                        <div class="row align-items-center">
                            <div class="col-lg-2 col-5">
                                <div class="brand-logo">
                                    <a href="<?php echo e(route('front.index')); ?>" class="logo"><img class="lazy" data-src="<?php echo e(asset('assets/front/img/'.$bs->footer_logo)); ?>" alt=""></a>
                                </div>
                            </div>
                            <div class="col-lg-10 col-7">
                                <?php if ($__env->exists('front.ecommerce.partials.navbar')) echo $__env->make('front.ecommerce.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header><!--====== End header-area ======--><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/ecommerce/partials/header.blade.php ENDPATH**/ ?>