<?php $__env->startSection('pagename'); ?>
 -
 <?php echo e(__('Cart')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->cart_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->cart_meta_description"); ?>


<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/jquery-ui.min.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('breadcrumb-title', convertUtf8($be->cart_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($be->cart_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Cart')); ?>

<?php $__env->startSection('content'); ?>

<!--====== SHOPPING CART PART START ======-->

<section class="cart-area">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <?php if($cart != null): ?>
                    <ul class="total-item-info">
                        <?php
                            $cartTotal = 0;
                            $countitem = 0;
                            if($cart){
                            foreach($cart as $p){
                                $cartTotal += $p['price'] * $p['qty'];
                                $countitem += $p['qty'];
                            }
                        }
                        ?>
                        <li><strong><?php echo e(__('Total Items')); ?>:</strong> <strong class="cart-item-view"><?php echo e($cart ? $countitem : 0); ?></strong></li>
                        <li><strong><?php echo e(__('Cart Total')); ?> :</strong>  <strong class="cart-total-view"><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?> <?php echo e($cartTotal); ?> <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></strong></li>
                    </ul>
                <?php endif; ?>
                <div class="table-outer">
                    <?php if($cart != null): ?>
                    <table class="cart-table">
                        <thead class="cart-header">
                            <tr>
                                <th class="prod-column"><?php echo e(__('Products')); ?></th>
                                <th class="hide-column"></th>
                                <th><?php echo e(__('Quantity')); ?></th>
                                <th class="availability"><?php echo e(__('Availability')); ?></th>
                                <th class="price"><?php echo e(__('Price')); ?></th>
                                <th><?php echo e(__('Total')); ?></th>
                                <th><?php echo e(__('Remove')); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $product = App\Product::findOrFail($id);
                            ?>
                            <tr class="remove<?php echo e($id); ?>">

                                <td colspan="2" class="prod-column">
                                    <div class="column-box">
                                        <div class="title pl-0">
                                            <a target="_blank" href="<?php echo e(route('front.product.details',$product->slug)); ?>"><h3 class="prod-title"><?php echo e(convertUtf8($item['name'])); ?></h3></a>
                                        </div>
                                    </div>
                                </td>
                                <td class="qty">
                                    <div class="product-quantity d-flex mb-35" id="quantity">
                                        <button type="button" id="sub" class="sub">-</button>
                                        <input type="text" class="cart_qty" id="1" value="<?php echo e($item['qty']); ?>" />
                                        <button type="button" id="add" class="add">+</button>
                                    </div>
                                </td>
                                <input type="hidden" value="<?php echo e($id); ?>" class="product_id">
                                <td class="unit-price">
                                    <div class="available-info">
                                        <?php if($product->type == 'digital'): ?>
                                            <span class="icon fa fa-check thm-bg-clr"></span><?php echo e(__('Item(s)')); ?><br><?php echo e(__('Avilable Now')); ?>

                                        <?php else: ?>
                                            <?php if($product->stock >= $item['qty']): ?>
                                                <span class="icon fa fa-check thm-bg-clr"></span><?php echo e(__('Item(s)')); ?><br><?php echo e(__('Avilable Now')); ?>

                                            <?php else: ?>
                                                <span class="icon fa fa-times thm-bg-rmv"></span><?php echo e(__('Item(s)')); ?><br><?php echo e(__('Out Of Stock')); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="price cart_price"><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?> <span><?php echo e($item['price']); ?></span> <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></td>
                                <td class="sub-total"><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?> <span><?php echo e($item['qty'] * $item['price']); ?></span> <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></td>
                                <td>
                                    <div class="remove">
                                        <div class="checkbox">
                                        <span class="fas fa-times item-remove" rel="<?php echo e($id); ?>" data-href="<?php echo e(route('cart.item.remove',$id)); ?>"></span>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php else: ?>
                        <div class="bg-light py-5 text-center">
                            <h3 class="text-uppercase"><?php echo e(__('Cart is empty!')); ?></h3>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php if($cart != null): ?>
            <div class="row cart-middle">
                <div class="col-lg-6 offset-lg-6 col-sm-12">
                    <div class="update-cart float-right d-inline-block ml-4">
                        <a class="proceed-checkout-btn" href="<?php echo e(route('front.checkout')); ?>" type="button"><span><?php echo e(__('Checkout')); ?></span></a>
                    </div>
                    <div class="update-cart float-right d-inline-block">
                        <button class="main-btn main-btn-2" id="cartUpdate" data-href="<?php echo e(route('cart.update')); ?>" type="button"><span><?php echo e(__('Update Cart')); ?></span></button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<!--====== SHOPPING CART PART ENDS ======-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    var symbol = "<?php echo e($bex->base_currency_symbol); ?>";
    var position = "<?php echo e($bex->base_currency_symbol_position); ?>";
</script>
<script src="<?php echo e(asset('assets/front/js/jquery.ui.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/product.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/cart.js')); ?>"></script>

<script>


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/product/cart.blade.php ENDPATH**/ ?>