<?php $__env->startSection('pagename'); ?>
- <?php echo e(__('Gallery')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->gallery_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->gallery_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $bs->gallery_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $bs->gallery_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('GALLERY')); ?>

<?php $__env->startSection('content'); ?>
<!--    Gallery section start   -->
<section class="gallery-area-v1" id="masonry-gallery">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-10">
        <?php if(count($categories) > 0 && $bex->gallery_category_status == 1): ?>
          <div class="filter-nav text-center mb-15">
            <ul class="filter-btn">
              <li data-filter="*" class="active"><?php echo e(__('All')); ?></li>
              <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $filterValue = "." . Str::slug($category->name);
                ?>

                <li data-filter="<?php echo e($filterValue); ?>"><?php echo e(convertUtf8($category->name)); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="masonry-row">
      <div class="row">
        <?php if(count($galleries) == 0): ?>
          <div class="col">
            <h3 class="text-center"><?php echo e(__('No Gallery Image Found!')); ?></h3>
          </div>
        <?php else: ?>
          <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              $galleryCategory = $gallery->galleryImgCategory()->first();

              if (!empty($galleryCategory)) {
                $categoryName = Str::slug($galleryCategory->name);
              } else {
                $categoryName = "";
              }
            ?>

            <div class="col-lg-4 col-md-6 col-sm-12 galery-column <?php echo e($categoryName); ?>">
              <div class="gallery-item mb-30">
                <div class="gallery-img">
                  <a href="<?php echo e(asset('assets/front/img/gallery/' . $gallery->image)); ?>" class="img-popup">
                    <img src="<?php echo e(asset('assets/front/img/gallery/' . $gallery->image)); ?>" alt="gallery">
                  </a>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
<!--    Gallery section end   -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script>
    $('#masonry-gallery').imagesLoaded( function() {
      // items on button click
      $('.filter-btn').on('click', 'li', function () {
        var filterValue = $(this).attr('data-filter');
        $grid.isotope({
          filter: filterValue
        });
      });
      // menu active class
      $('.filter-btn li').on('click', function (e) {
        $(this).siblings('.active').removeClass('active');
        $(this).addClass('active');
        e.preventDefault();
      });
      var $grid = $('.masonry-row').isotope({
        itemSelector: '.galery-column',
        percentPosition: true,
        masonry: {
          columnWidth: 0
        }
      });
    });

    //===== Magnific Popup
    $('.img-popup').magnificPopup({
      type: 'image',
      gallery: {
        enabled: true
      }
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/gallery.blade.php ENDPATH**/ ?>