<?php $__env->startSection('styles'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/nice-select.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/jquery.nice-number.min.css')); ?>">
  <style>
    input {
      margin-bottom: 10px;
    }

    .anonymous_user {
      font-size: 14px;
      text-align: center;
      margin-top: 20px;
    }

    .anonymous_user input {
      height: 14px;
      width: 14px;
      margin-right: 5px;
    }

    #stripe-section,
    #razorpay-section,
    #payumoney-section {
      margin-top: 10px;
    }

    .gateway-desc {
      background: #f1f1f1;
      font-size: 14px;
      padding: 10px 25px;
      margin-bottom: 20px;
      color: #212529;
      margin-top: 20px;
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('Event')); ?> - <?php echo e(convertUtf8($event->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$event->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$event->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $bs->event_details_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', strlen($event->title) > 30 ? mb_substr($event->title, 0, 30, 'utf-8') . '...' :
  $event->title); ?>
<?php $__env->startSection('breadcrumb-link', __('Event Details')); ?>

<?php $__env->startSection('content'); ?>
  <!--====== Start Event details Section ======-->
  <section class="event-details-section pt-130 pb-140">
    <div class="container">
      <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($error); ?></strong>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
      <div class="row">
        <div class="col-lg-6">
          <?php if($event->image != 'null'): ?>
            <div class="event-big-slide mb-30">
              <?php $__currentLoopData = json_decode($event->image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-img">
                  <a href="<?php echo e(asset('/assets/front/img/events/sliders/' . $event_image)); ?>" class="image-popup">
                    <img src="<?php echo e(asset('/assets/front/img/events/sliders/' . $event_image)); ?>" class="img-fluid"
                      alt="" width="700" height="500">
                  </a>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="event-thumb-slide">
              <?php $__currentLoopData = json_decode($event->image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-img">
                  <img src="<?php echo e(asset('/assets/front/img/events/sliders/' . $event_image)); ?>" class="img-fluid"
                    alt="">
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          <?php endif; ?>
        </div>
        <div class="col-lg-6">
          <div class="event-details-wrapper">
            <div class="event-content">
              <h3><?php echo e(convertUtf8($event->title)); ?></h3>
              <div class="event-meta mb-2">
                <span class="date"><i
                    class="far fa-calendar-alt"></i><?php echo e(date_format(date_create($event->date), 'M d,Y')); ?></span>
                <?php if(!empty($event->venue_location)): ?>
                  <span class="location"><i class="fas fa-map-marker-alt"></i><?php echo e($event->venue_location); ?></span>
                <?php endif; ?>
              </div>
              <p class="price base-color">
                <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($event->cost); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                / <?php echo e(__('per ticket')); ?></p>
              <div id="purchase-section" style="display: block">
                <div class="time-count">
                  <div id="simple_timer"></div>
                </div>
                <p><?php echo replaceBaseUrl(convertUtf8($event->content)); ?></p>
                <div class="info-box mb-15">
                  <a class="base-color"
                    href="<?php echo e(route('front.events', ['category' => $event->cat_id])); ?>"><?php echo e($event->eventCategories->name); ?></a>
                  <p><?php echo e($event->venue_location); ?></p>
                </div>

                <?php if($event->available_tickets > 0): ?>
                  <ul class="mb-20" style="display: flex">
                    <li><input type="number" id="tickets" min="1" max="<?php echo e($event->available_tickets); ?>">
                    </li>
                    <li><input type="hidden" id="cost" value="<?php echo e($event->cost); ?>"></li>
                    <?php if(!is_null($event->video)): ?>
                      <li><a href="<?php echo e(asset('/assets/front/img/events/videos/' . $event->video)); ?>" class="play_btn"><i
                            class="fas fa-play"></i></a></li>
                      <li>
                    <?php endif; ?>
                  </ul>
                  <a href="javascript:void(0)" class="main-btn" id="addToCart"><?php echo e(__('Add To Cart')); ?></a>
                <?php else: ?>
                  <div><?php echo e(__('No tickets are available')); ?></div>
                <?php endif; ?>
              </div>
              <?php
                if (Auth::check()) {
                    $name = Auth::user()->fname;
                    $email = Auth::user()->email;
                    $phone = Auth::user()->number;
                } else {
                    $name = '';
                    $email = '';
                    $phone = '';
                }
              ?>

              <div id="invoice-section" style="display: none; justify-content: center; text-align: center">
                <?php if($bex->event_guest_checkout == 1 && !Auth::check()): ?>
                  <div class="alert alert-warning">
                    <?php echo e(__('You are now purchasing ticket as a guest. If you want to login before purchasing, then please')); ?>

                    <a href="<?php echo e(route('user.login', ['redirected' => 'event'])); ?>"><?php echo e(__('Click Here')); ?></a>
                  </div>
                <?php endif; ?>
                <form action="<?php echo e(route('front.event.payment')); ?>" method="POST" enctype="multipart/form-data" id="eventForm">
                  <?php echo csrf_field(); ?>
                  <hr>
                  <h4><?php echo e(__('Invoice')); ?></h4>
                  <hr>
                  <input type="hidden" name="event_id" value="<?php echo e($event->id); ?>">
                  <input type="hidden" name="event_slug" value="<?php echo e($event->slug); ?>">
                  <div><?php echo e(__('No. Of Tickets')); ?>: <span id="quantity">5</span></div>
                  <input type="hidden" name="ticket_quantity" id="ticket-quantity" value="">
                  <div><?php echo e(__('Per Ticket Cost')); ?>:
                    <span><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($event->cost); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                    </span>
                  </div>
                  <input type="hidden" name="ticket_cost" id="ticket-cost" value="<?php echo e($event->cost); ?>">
                  <div><?php echo e(__('Total Cost')); ?>:
                    <span><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><span
                        id="total">100</span><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></span>
                  </div>
                  <input type="hidden" name="total_cost" id="total-cost" value="">
                  <br>
                  <div id="donation-info-section">
                    <input type="text" class="form_control" name="name" placeholder="<?php echo e(__('Enter your name')); ?>"
                      value="<?php echo e($name); ?>">
                    <input type="email" class="form_control" name="email"
                      placeholder="<?php echo e(__('Enter your email address')); ?>" value="<?php echo e($email); ?>">
                    <input type="text" class="form_control" name="phone" placeholder="<?php echo e(__('Enter your phone')); ?>"
                      value="<?php echo e($phone); ?>">
                  </div>
                  <div class="form_group" style="display: flex; flex-direction: column; margin-top: 20px">
                    <select name="payment_method" id="payment-method">
                      <option value="0"><?php echo e(__('Choose an option')); ?></option>
                      <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($payment_gateway->name); ?>"><?php echo e($payment_gateway->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                  <div id="stripe-section" style="display: none">
                    <div id="stripe-element">
                      <!-- A Stripe Element will be inserted here. -->
                    </div>
                    <!-- Used to display form errors -->
                    <div id="stripe-errors" class="pb-2 text-danger text-left" role="alert"></div>
                  </div>
                  <div id="razorpay-section" style="display: none">
                    <input type="text" class="form_control" name="razorpay_phone"
                      placeholder="<?php echo e(__('Enter your phone')); ?>">
                    <input type="text" class="form_control" name="razorpay_address"
                      placeholder="<?php echo e(__('Enter your address')); ?>">
                  </div>
                  <div id="payumoney-section" style="display: none">
                    <input type="text" class="form_control" name="payumoney_first_name"
                      placeholder="<?php echo e(__('First Name')); ?>">
                    <input type="text" class="form_control" name="payumoney_last_name"
                      placeholder="<?php echo e(__('Last Name')); ?>">
                    <input type="text" class="form_control" name="payumoney_phone"
                      placeholder="<?php echo e(__('Phone')); ?>">
                  </div>
                  <div id="instructions">

                  </div>
                  <input type="hidden" name="is_receipt" value="0" id="is_receipt">
                  <div class="form_group"
                    style="display: flex; flex-direction: row;justify-content: space-between; text-align: center;margin-top: 20px;">
                    <a href="javascript:void(0)" class="main-btn" id="cancel"
                      style="height: 45px;justify-content: center;text-align: center;"><?php echo e(__('Cancel')); ?></a>
                    <button class="main-btn" type="submit"
                      style="height: 45px;justify-content: center;text-align: center;padding-top: 0;padding-bottom: 0;">
                      <?php echo e(__('Confirm')); ?>

                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-12">
          <div class="discription-area mt-80 mb-50">
            <div class="discription-tabs">
              <ul class="nav nav-tabs">
                <li class="nav-item">
                  <a class="nav-link active" data-toggle="tab" href="#description"><?php echo e(__('Details')); ?></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#organizer"><?php echo e(__('Organizer')); ?></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#vanue"><?php echo e(__('Venue')); ?></a>
                </li>
              </ul>
            </div>
            <div class="tab-content">
              <div id="description" class="tab-pane active">
                <div class="event-content-box">
                  <div class="info">
                    <span><?php echo e(__('Start')); ?>:</span>
                    <p><?php echo e(date_format(date_create($event->date), 'M d,Y')); ?>

                      @ <?php echo e(date_format(date_create($event->time), 'h:i:sa')); ?></p>
                  </div>
                  <div class="info">
                    <span><?php echo e(__('Cost')); ?>:</span>
                    <p>
                      <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($event->cost); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                    </p>
                  </div>
                  <div class="info">
                    <span><?php echo e(__('Event Categories')); ?>:</span>
                    <p><?php echo e(convertUtf8($event->eventCategories->name)); ?>, <?php echo e(__('Event')); ?></p>
                  </div>
                </div>
              </div>
              <div id="organizer" class="tab-pane fade">
                <div class="event-content-box">
                  <h4><?php echo e(convertUtf8($event->organizer)); ?></h4>
                  <?php if(!empty($event->organizer_email)): ?>
                    <div class="info">
                      <span><?php echo e(__('Email')); ?>:</span>
                      <p><a href="<?php echo e($event->organizer_email); ?>"><?php echo e(convertUtf8($event->organizer_email)); ?></a></p>
                    </div>
                  <?php endif; ?>
                  <?php if(!empty($event->organizer_website)): ?>
                    <div class="info">
                      <span><?php echo e(__('Website')); ?>:</span>
                      <p><a href="<?php echo e($event->organizer_website); ?>"><?php echo e(convertUtf8($event->organizer_website)); ?></a></p>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
              <div id="vanue" class="tab-pane fade">
                <div class="event-content-box">
                  <h4><?php echo e(convertUtf8($event->title)); ?></h4>
                  <p><?php echo e(convertUtf8($event->venue)); ?> <br><?php echo e(convertUtf8($event->venue_location)); ?></p>
                  <?php if(!empty($event->venue_location)): ?>
                    <div class="map-box">
                      <iframe id="gmap_canvas"
                        src="https://maps.google.com/maps?q=<?php echo e($event->venue_location); ?>&t=&z=13&ie=UTF8&iwloc=&output=embed"></iframe>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php if(count($moreEvents) > 0): ?>
        <div class="row recent-event mb-30">
          <div class="col-lg-12">
            <h4 class="title"><?php echo e(__('MAYBE YOU LIKE')); ?></h4>
            <?php $__currentLoopData = $moreEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $moreEvent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="event-item">
                <div class="event-img">
                  <img data-src="<?php echo e(asset('/assets/front/img/events/sliders/' . json_decode($moreEvent->image)[0])); ?>"
                    class="img-fluid lazy" alt="">
                </div>
                <div class="event-content">
                  <h4><a
                      href="<?php echo e(route('front.event_details', [$moreEvent->slug])); ?>"><?php echo e(convertUtf8($moreEvent->title)); ?></a>
                  </h4>
                  <div class="post-meta mb-2">
                    <?php if(!empty($moreEvent->venue_location)): ?>
                      <span><a href="#"><?php echo e(convertUtf8($moreEvent->venue_location)); ?></a></span>
                    <?php endif; ?>
                    <span>
                      <a href="#"><?php echo e(date_format(date_create($moreEvent->date), 'd M Y')); ?></a>
                    </span>
                  </div>

                  <p class="price base-color">
                    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($moreEvent->cost); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                  </p>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      <?php endif; ?>
    </div>
  </section>
  <!--====== End Event details Section ======-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    let stripe_key = "<?php echo e($stripe_key); ?>";
  </script>
  <script src="https://js.stripe.com/v3/"></script>
  <script src="<?php echo e(asset('assets/front/js/event-checkout-stripe.js')); ?>"></script>

  <script src="<?php echo e(asset('/assets/front/js/jquery.nice-select.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/front/js/jquery.nice-number.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/front/js/jquery.easypiechart.min.js')); ?>"></script>
  
  <script src="<?php echo e(asset('/assets/front/js/event.js')); ?>"></script>
  <script type="text/javascript">
    const d = new Date('<?php echo $event->date; ?>');
    const ye = parseInt(new Intl.DateTimeFormat('en', {
      year: 'numeric'
    }).format(d));
    const mo = parseInt(new Intl.DateTimeFormat('en', {
      month: 'numeric'
    }).format(d));
    const da = parseInt(new Intl.DateTimeFormat('en', {
      day: '2-digit'
    }).format(d));
    const t = ' <?php echo $event->time; ?>';
    const time = t.split(":");
    const hr = parseInt(time[0]);
    const min = parseInt(time[1]);
    $('#simple_timer').syotimer({
      year: ye,
      month: mo,
      day: da,
      hour: hr,
      minute: min,
    });
  </script>
  <script>
    $(document).ready(function() {
      $("#addToCart").on('click', function() {
        const quantity = $("#tickets").val();
        const cost = $("#cost").val();
        const total = quantity * cost;
        $("#quantity").html(`<span>${quantity}<span/>`);
        $("#ticket-quantity").val(quantity);
        $("#total").html(`<span>${total}<span/>`);
        $("#total-cost").val(total);
        $("#purchase-section").css('display', 'none');
        $("#invoice-section").css('display', 'block');
      })
      $("#cancel").on('click', function() {
        $("#purchase-section").css('display', 'block');
        $("#invoice-section").css('display', 'none');
      });
      $("#payment-method").change(function() {
        var selectedPaymentMethod = $(this).children("option:selected").val();
        let offline = <?php echo $offline; ?>;
        let data = [];
        offline.map(({
          id,
          name
        }) => {
          data.push(name);
        });
        if (selectedPaymentMethod == "Stripe") {
          $('#razorpay-section').fadeOut();
          $('#payumoney-section').fadeOut();
          $('#stripe-section').fadeIn(5);
        } else if (selectedPaymentMethod == "Razorpay") {
          $('#stripe-section').fadeOut();
          $('#payumoney-section').fadeOut();
          $('#razorpay-section').fadeIn(5);
        } else if (selectedPaymentMethod == "PayUmoney") {
          $('#stripe-section').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#payumoney-section').fadeIn(5);
        } else if (data.indexOf(selectedPaymentMethod) !== -1) {
          $('#stripe-section').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#payumoney-section').fadeOut();
          //ajax call for instructions
          let name = selectedPaymentMethod;
          let formData = new FormData();
          formData.append('name', name);
          $.ajax({
            url: '<?php echo e(route('front.payment.instructions')); ?>',
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            contentType: false,
            processData: false,
            cache: false,
            data: formData,
            success: function(data) {
              console.log(data);
              let instruction = $("#instructions");
              let instructions = `<div class="gateway-desc">${data.instructions}</div>`;
              let description = `<div class="gateway-desc"><p>${data.description}</p></div>`;
              let receipt = `<div class="form-element mb-2">
                                        <label>Receipt  <span>**</span> </label>
                                        <input type="file" name="receipt" value="" class="file-input">
                                        <p class="mb-0 text-warning">** Receipt image must be .jpg / .jpeg / .png</p>
                                    </div>`;
              if (data.is_receipt === 1) {
                $("#is_receipt").val(1);
                let finalInstruction = instructions + description + receipt;
                instruction.html(finalInstruction);
              } else {
                $("#is_receipt").val(0);
                let finalInstruction = instructions + description;
                instruction.html(finalInstruction);
              }
              $('#instructions').fadeIn();
            },
            error: function(data) {
              console.log(data);
            }
          })
        } else {
          $('#stripe-section').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#payumoney-section').fadeOut();
          $('#instructions').fadeOut();
        }
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/event-details.blade.php ENDPATH**/ ?>