<?php $__env->startSection('pagename'); ?>
 - <?php echo e(__('Product')); ?> - <?php echo e(convertUtf8($product->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/slick.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$product->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$product->meta_description"); ?>

<?php
    $reviews = App\ProductReview::where('product_id', $product->id)->get();
    $avarage_rating = App\ProductReview::where('product_id',$product->id)->avg('review');
    $avarage_rating =  round($avarage_rating,2);

?>

<?php $__env->startSection('breadcrumb-title', $be->product_details_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', strlen($product->title) > 40 ? mb_substr($product->title,0,40,'utf-8') . '...' : $product->title); ?>
<?php $__env->startSection('breadcrumb-link', strlen($product->title) > 40 ? mb_substr($product->title,0,40,'utf-8') . '...' : $product->title); ?>

<?php $__env->startSection('content'); ?>


<!--====== PRODUCT DETAILS PART START ======-->

<div class="product-details-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="product-item-slide ">
                    <?php $__currentLoopData = $product->product_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item pt-30">
                        <a class="image-popup" href="<?php echo e(asset('assets/front/img/product/sliders/'.$image->image)); ?>"><img src="<?php echo e(asset('assets/front/img/product/sliders/'.$image->image)); ?>" alt=""></a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="product-details-slide-item mt-30">
                    <ul class="d-flex">
                        <?php $__currentLoopData = $product->product_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><img src="<?php echo e(asset('assets/front/img/product/sliders/'.$image->image)); ?>" alt=""></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="product-details-content ml-60 mt-30">
                    <div class="product-details-content-item">
                        <h4 class="title <?php echo e($bex->product_rating_system == 0 ? 'pb-0' : ''); ?>"><?php echo e(convertUtf8($product->title)); ?></h4>
                        <div class="d-flex justify-content-between">
                            <?php if($bex->product_rating_system == 1): ?>
                            <div class="rate">
                                <div class="rating" style="width:<?php echo e($product->rating * 20); ?>%"></div>
                            </div>
                            <?php endif; ?>
                            <?php if($product->type != 'digital'): ?>
                                <?php if($product->stock > 0): ?>
                                    <h4 class="badge badge-success">
                                        <i class="far fa-check-circle"></i> <?php echo e(__('In Stock')); ?>

                                    </h4>
                                <?php else: ?>
                                    <h4 class="badge badge-danger">
                                        <i class="far fa-times-circle"></i> <?php echo e(__('Out of Stock')); ?>

                                    </h4>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>

                        <?php if($bex->catalog_mode == 0): ?>
                            <span><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->current_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                            <?php if(!empty($product->previous_price)): ?>
                                <del>  <span class="prepice"> <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->previous_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></span></del>
                            <?php endif; ?>
                            </span>
                        <?php endif; ?>

                        <?php if(!empty($product->summary)): ?>
                        <p><?php echo e(convertUtf8($product->summary)); ?></p>
                        <?php endif; ?>
                    </div>

                    <?php if($product->type != 'digital' && $bex->catalog_mode == 0): ?>
                    <div class="product-btns d-block d-sm-flex align-items-center mt-40">
                        <div class="product-quantity  d-flex" id="quantity">
                            <button type="button" id="sub" class="sub subclick">-</button>
                            <input type="text" class="cart-amount" id="1" value="1" />
                            <button type="button" id="add" class="add addclick">+</button>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if($bex->catalog_mode == 0): ?>
                        <div class="actions">
                            <a class="main-btn cart-btn cart-link d-inline-block" data-href="<?php echo e(route('add.cart',$product->id)); ?>"><?php echo e(__('Add To Cart')); ?></a>
                            <form class="d-inline-block ml-2" method="GET" action="<?php echo e(route('front.product.checkout',$product->slug)); ?>">
                                <input type="hidden" value="" name="qty" id="order_click_with_qty">
                                <button type="submit" class="main-btn checkout-btn" ><?php echo e(__('Order Now')); ?></button>
                            </form>
                        </div>
                    <?php endif; ?>

                    <div class="product-social-icon social-link a2a_kit a2a_kit_size_32">
                        <ul class="social-share">
                            <li>
                                <a class="facebook a2a_button_facebook" href="">
                                  <i class="fab fa-facebook-f"></i>
                                </a>
                              </li>
                                <li>
                                    <a class="twitter a2a_button_twitter" href="">
                                      <i class="fab fa-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="linkedin a2a_button_linkedin" href="">
                                      <i class="fab fa-linkedin-in"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="pinterest a2a_button_pinterest" href="">
                                      <i class="fab fa-pinterest"></i>
                                    </a>
                                </li>
                                <li>

                                <a class="a2a_dd plus" href="https://www.addtoany.com/share">
                                    <i class="fas fa-plus"></i>
                                  </a>
                                </li>
                        </ul>
                    </div>
                    <script async src="https://static.addtoany.com/menu/page.js"></script>
                    <div class="product-details-tags">
                        <ul>
                            <?php if(!empty($product->sku)): ?>
                            <li><span><?php echo e(__('SKU')); ?>:</span> <?php echo e($product->sku); ?> </li>
                            <?php endif; ?>
                            <?php if(!empty($product->category)): ?>
                            <li><span><?php echo e(__('Category')); ?>:</span> <a href="<?php echo e(route('front.product').'?category_id='.$product->category_id); ?>"><?php echo e($product->category ? convertUtf8($product->category->name) : ''); ?></a> </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--====== PRODUCT DETAILS PART ENDS ======-->

<!--====== SHOP TAB PART START ======-->

<div class="shop-tab-area" <?php if($related_product->count() == 0): ?> style="padding-bottom:120px;" <?php endif; ?>>
    <div class="container">
        <div class="row">
            <div class="col-lg-11">
                <div class="shop-tab-area">
                    <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                        <li class="nav-item">
                        <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true"><?php echo e(__('Description')); ?></a>
                        </li>
                        <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
                        <li class="nav-item">
                            <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#pills-contact" role="tab" aria-controls="pills-contact" aria-selected="false"><?php echo e(__('Reviews')); ?> (<?php echo e(count($reviews)); ?>)</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                                <?php echo replaceBaseUrl(convertUtf8($product->description)); ?>


                        </div>
                        <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
                        <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab">
                            <div class="shop-review-area">
                                <div class="shop-review-title">
                                    <h3 class="title"><?php echo e(convertUtf8($product->title)); ?></h3>
                                </div>
                                <?php if(count($reviews) > 0): ?>
                                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="shop-review-user">
                                        <?php if(strpos($review->user->photo, 'facebook') !== false || strpos($review->user->photo, 'google')): ?>
                                            <img class="lazy" data-src="<?php echo e($review->user->photo ? $review->user->photo : asset('assets/front/img/user/profile.jpg')); ?>" alt="user image" width="60">
                                        <?php else: ?>
                                            <img class="lazy" data-src="<?php echo e($review->user->photo ? asset('assets/front/img/user/'.$review->user->photo) : ''); ?>" alt="user image" width="60">
                                        <?php endif; ?>
                                        <ul>
                                            <div class="rate">
                                                <div class="rating" style="width:<?php echo e($review->review * 20); ?>%"></div>
                                            </div>
                                        </ul>
                                        <span><span><?php echo e(convertUtf8($review->user->username)); ?></span> – <?php echo e($review->created_at->format('d-m-Y')); ?></span>
                                        <p><?php echo e(convertUtf8($review->comment)); ?></p>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="bg-light mt-4 text-center py-5">
                                        <?php echo e(__('NOT RATED YET')); ?>

                                    </div>
                                <?php endif; ?>
                                    <?php if(Auth::user()): ?>
                                        <?php if(App\OrderItem::where('user_id',Auth::user()->id)->where('product_id',$product->id)->exists()): ?>
                                    <div class="shop-review-form">
                                        <?php $__errorArgs = ['error'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="text-danger my-2"><?php echo e(Session::get('error')); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <form class="mt-5" action="<?php echo e(route('product.review.submit')); ?>" method="POST"><?php echo csrf_field(); ?>
                                            <div class="input-box">
                                                <span><?php echo e(__('Comment')); ?></span>
                                                <textarea name="comment"  cols="30" rows="10" placeholder="<?php echo e(__('Comment')); ?>"></textarea>
                                            </div>
                                            <input type="hidden" value="" id="reviewValue" name="review">
                                            <input type="hidden" value="<?php echo e($product->id); ?>" name="product_id">
                                            <div class="input-box">
                                                <span><?php echo e(__('Rating')); ?> *</span>
                                                <div class="review-content ">
                                                <ul class="review-value review-1">
                                                    <li><a class="cursor-pointer" data-href="1"><i class="far fa-star"></i></a></li>
                                                </ul>
                                                <ul class="review-value review-2">
                                                    <li><a class="cursor-pointer" data-href="2"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="2"><i class="far fa-star"></i></a></li>
                                                </ul>
                                                <ul class="review-value review-3">
                                                    <li><a class="cursor-pointer" data-href="3"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="3"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="3"><i class="far fa-star"></i></a></li>
                                                </ul>
                                                <ul class="review-value review-4">
                                                    <li><a class="cursor-pointer" data-href="4"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="4"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="4"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="4"><i class="far fa-star"></i></a></li>
                                                </ul>
                                                <ul class="review-value review-5">
                                                    <li><a class="cursor-pointer" data-href="5"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="5"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="5"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="5"><i class="far fa-star"></i></a></li>
                                                    <li><a class="cursor-pointer" data-href="5"><i class="far fa-star"></i></a></li>
                                                </ul>
                                            </div>
                                            </div>
                                            <div class="input-btn mt-3">
                                                <button type="submit"><?php echo e(__('Submit')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                    <?php endif; ?>
                                    <?php else: ?>
                                    <div class="review-login mt-5">
                                        <a class="boxed-btn d-inline-block mr-2" href="<?php echo e(route('user.login')); ?>"><?php echo e(__('Login')); ?></a> <?php echo e(__('to leave a rating')); ?>

                                    </div>
                                    <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--====== SHOP TAB PART ENDS ======-->


<?php if($related_product->count() > 0): ?>
<!--====== product items PART ENDS ======-->
<div class="product-items">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <span class="section-title"><?php echo e(__('Related Products')); ?></span>
                <h2 class="section-summary"<?php echo e(__('>Have a look at the finlance latest Product')); ?>></h2>
            </div>
        </div>

        <div class="owl-carousel shop-item-slide-2">

             <?php $__currentLoopData = $related_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 <div class="shop-item">
                    <div class="shop-thumb">
                        <img class="lazy" data-src="<?php echo e(asset('assets/front/img/product/featured/'.$product->feature_image)); ?>" alt="">
                        <ul>

                            <?php if($bex->catalog_mode == 0): ?>
                                <li><a href="<?php echo e(route('front.product.checkout',$product->slug)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Order Now')); ?>"><i class="far fa-credit-card"></i></a></li>

                                <li><a class="cart-link" data-href="<?php echo e(route('add.cart',$product->id)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Add to Cart')); ?>"><i class="fas fa-shopping-cart"></i></a></li>
                            <?php endif; ?>

                            <li><a href="<?php echo e(route('front.product.details',$product->slug)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('View Details')); ?>"><i class="fas fa-eye"></i></a></li>
                        </ul>
                    </div>
                    <div class="shop-content text-center <?php echo e($bex->catalog_mode == 1 ? 'pt-3' : ''); ?>">
                        <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
                        <div class="rate">
                            <div class="rating" style="width:<?php echo e($product->rating * 20); ?>%"></div>
                        </div>
                        <?php endif; ?>
                        <a class="<?php echo e($bex->product_rating_system == 0 ? 'mt-3' : ''); ?>" href="<?php echo e(route('front.product.details',$product->slug)); ?>"><?php echo e(convertUtf8($product->title)); ?></a> <br>

                        <?php if($bex->catalog_mode == 0): ?>

                            <span>
                                <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->current_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                                <?php if(!empty($product->previous_price)): ?>
                                    <del>  <span class="prepice"> <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->previous_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></span></del>
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </div>

    </div>
</div>
<?php endif; ?>
<!--====== product items PART ENDS ======-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(asset('assets/front/js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/product.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/cart.js')); ?>"></script>
<script>
    $('.image-popup').magnificPopup({
        type: 'image',
        gallery:{
            enabled:true
        }
    });

</script>

<script>
    $(document).on('click','.review-value li a',function(){
        $('.review-value li a i').removeClass('text-primary');
        let reviewValue = $(this).attr('data-href');
         parentClass = `review-${reviewValue}`;
        $('.'+parentClass+ ' li a i').addClass('text-primary');
        $('#reviewValue').val(reviewValue);
    })
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/product/details.blade.php ENDPATH**/ ?>