<?php $__env->startSection('pagename'); ?>
 - <?php echo e(__('Event Calendar')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->calendar_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->calendar_meta_description"); ?>

<?php $__env->startSection('styles'); ?>
<link href='<?php echo e(asset('assets/front/css/calendar.css')); ?>' rel='stylesheet' />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($be->event_calendar_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($be->event_calendar_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', convertUtf8($be->event_calendar_title)); ?>


<?php $__env->startSection('content'); ?>

  <!--   about company section start   -->
  <div class="about-company-section pt-105 pb-115">
     <div class="container">
        <div class="row">
           <div class="col-lg-12">
              <div id='calendar'></div>
           </div>
        </div>
     </div>
  </div>
  <!--   about company section end   -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>

    var events = <?php echo json_encode($formattedEvents); ?>;
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();

    today = yyyy + '-' + mm + '-' + dd;

    document.addEventListener('DOMContentLoaded', function() {
      var calendarEl = document.getElementById('calendar');

      var calendar = new FullCalendar.Calendar(calendarEl, {
        plugins: [ 'dayGrid', 'timeGrid', 'list', 'interaction' ],
        header: {
          left: 'prev,next today',
          center: 'title',
          right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
        },
        buttonText: {
            today: "<?php echo e(__('today')); ?>",
            month: "<?php echo e(__('month')); ?>",
            week: "<?php echo e(__('week')); ?>",
            day: "<?php echo e(__('day')); ?>",
            list: "<?php echo e(__('list')); ?>"
        },
        defaultDate: today,
        navLinks: true, // can click day/week names to navigate views
        editable: true,
        eventLimit: true, // allow "more" link when too many events
        events: events,
        locale: '<?php echo e($currentLang->code); ?>',
        dir: "<?php echo e($rtl == 1 ? 'rtl' : 'ltr'); ?>"
      });

      calendar.render();
    });

  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/calendar.blade.php ENDPATH**/ ?>