<?php $__env->startSection('content'); ?>
  <div class="page-header">
    <h4 class="page-title">
      <?php if(request()->path()=='admin/product/pending/orders'): ?>
        Pending
      <?php elseif(request()->path()=='admin/product/all/orders'): ?>
        All
      <?php elseif(request()->path()=='admin/product/processing/orders'): ?>
        Processing
      <?php elseif(request()->path()=='admin/product/completed/orders'): ?>
        Completed
      <?php elseif(request()->path()=='admin/product/rejected/orders'): ?>
        Rejcted
      <?php endif; ?>
      Orders
    </h4>
    <ul class="breadcrumbs">
      <li class="nav-home">
        <a href="<?php echo e(route('admin.dashboard')); ?>">
          <i class="flaticon-home"></i>
        </a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">Shop Management</a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">Manage Orders</a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">
            <?php if(request()->path()=='admin/product/pending/orders'): ?>
            Pending
          <?php elseif(request()->path()=='admin/product/all/orders'): ?>
            All
          <?php elseif(request()->path()=='admin/product/processing/orders'): ?>
            Processing
          <?php elseif(request()->path()=='admin/product/completed/orders'): ?>
            Completed
          <?php elseif(request()->path()=='admin/product/rejected/orders'): ?>
            Rejcted
          <?php elseif(request()->path()=='admin/product/search/orders'): ?>
            Search
          <?php endif; ?>
          Orders
        </a>
      </li>
    </ul>
  </div>
  <div class="row">
    <div class="col-md-12">

      <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card-title">
                        <?php if(request()->path()=='admin/product/pending/orders'): ?>
                            Pending
                        <?php elseif(request()->path()=='admin/product/all/orders'): ?>
                            All
                        <?php elseif(request()->path()=='admin/product/processing/orders'): ?>
                            Processing
                        <?php elseif(request()->path()=='admin/product/completed/orders'): ?>
                            Completed
                        <?php elseif(request()->path()=='admin/product/rejected/orders'): ?>
                            Rejcted
                         <?php elseif(request()->path()=='admin/product/search/orders'): ?>
                            Search
                        <?php endif; ?>
                        Orders
                    </div>
                </div>
                <div class="col-lg-6">
                    <button class="btn btn-danger float-right btn-md ml-4 d-none bulk-delete" data-href="<?php echo e(route('admin.product.order.bulk.delete')); ?>"><i class="flaticon-interface-5"></i> Delete</button>
                    <form action="<?php echo e(url()->current()); ?>" class="d-inline-block float-right">
                    <input class="form-control" type="text" name="search" placeholder="Search by Oder Number" value="<?php echo e(request()->input('search') ? request()->input('search') : ''); ?>">
                  </form>
              </div>
            </div>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-lg-12">
              <?php if(count($orders) == 0): ?>
                <h3 class="text-center">NO ORDER FOUND</h3>
              <?php else: ?>
                <div class="table-responsive">
                  <table class="table table-striped mt-3">
                    <thead>
                      <tr>
                        <th scope="col">
                            <input type="checkbox" class="bulk-check" data-val="all">
                        </th>

                        <th scope="col">Order Number</th>
                        <th scope="col" width="15%">Gateway</th>
                        <th scope="col">Total</th>
                        <th scope="col">Order Status</th>
                        <th scope="col">Payment Status</th>
                        <th scope="col">Receipt</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                          <td>
                            <input type="checkbox" class="bulk-check" data-val="<?php echo e($order->id); ?>">
                          </td>
                          <td>#<?php echo e($order->order_number); ?></td>
                          <td><?php echo e($order->method); ?></td>
                          <td><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?> <?php echo e(round($order->total,2)); ?> <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></td>
                          <td>
                            <form id="statusForm<?php echo e($order->id); ?>" class="d-inline-block" action="<?php echo e(route('admin.product.orders.status')); ?>" method="post">
                              <?php echo csrf_field(); ?>
                              <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                              <select class="form-control form-control-sm
                              <?php if($order->order_status == 'pending'): ?>
                                bg-warning
                              <?php elseif($order->order_status == 'processing'): ?>
                                bg-primary
                              <?php elseif($order->order_status == 'completed'): ?>
                                bg-success
                              <?php elseif($order->order_status == 'rejected'): ?>
                                bg-danger
                              <?php endif; ?>
                              " name="order_status" onchange="document.getElementById('statusForm<?php echo e($order->id); ?>').submit();">
                                <option value="pending" <?php echo e($order->order_status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="processing" <?php echo e($order->order_status == 'processing' ? 'selected' : ''); ?>>Processing</option>
                                <option value="completed" <?php echo e($order->order_status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                <option value="rejected" <?php echo e($order->order_status == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                              </select>
                            </form>
                          </td>

                          <td>
                              <?php if($order->gateway_type != 'offline'): ?>
                                  <?php if($order->payment_status == 'Completed'): ?>
                                    <span class="badge badge-success">Completed</span>
                                  <?php elseif($order->payment_status == 'Pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                  <?php endif; ?>
                              <?php elseif($order->gateway_type == 'offline'): ?>
                                <form action="<?php echo e(route('admin.product.paymentStatus')); ?>" id="paymentStatusForm<?php echo e($order->id); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                                    <select class="form-control-sm text-white border-0
                                    <?php if($order->payment_status == 'Completed'): ?>
                                        bg-success
                                    <?php elseif($order->payment_status == 'Pending'): ?>
                                        bg-warning
                                    <?php endif; ?>
                                    " name="payment_status" onchange="document.getElementById('paymentStatusForm<?php echo e($order->id); ?>').submit();">
                                        <option value="Pending" <?php echo e($order->payment_status == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                                        <option value="Completed" <?php echo e($order->payment_status == 'Completed' ? 'selected' : ''); ?>>Completed</option>
                                    </select>
                                </form>
                              <?php endif; ?>
                          </td>

                          <td>
                              <?php if(!empty($order->receipt)): ?>
                                <a class="btn btn-sm btn-info" href="#" data-toggle="modal" data-target="#receiptModal<?php echo e($order->id); ?>">Show</a>
                              <?php else: ?>
                                -
                              <?php endif; ?>
                          </td>

                          <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                  Actions
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                  <a class="dropdown-item" href="<?php echo e(route('admin.product.details', $order->id)); ?>" target="_blank">Details</a>
                                  <a class="dropdown-item" href="<?php echo e(asset('assets/front/invoices/product/'.$order->invoice_number)); ?>" target="_blank">Invoice</a>
                                    <form class="deleteform d-block" action="<?php echo e(route('admin.product.order.delete')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                                        <button type="submit" class="deletebtn">
                                        Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                          </td>
                        </tr>


                        
                        <div class="modal fade" id="receiptModal<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title" id="exampleModalLabel">Receipt Image</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                  </button>
                                </div>
                                <div class="modal-body">
                                    <img src="<?php echo e(asset('assets/front/receipt/' . $order->receipt)); ?>" alt="Receipt" width="100%">
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                              </div>
                            </div>
                          </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>

                <!-- Send Mail Modal -->
                <div class="modal fade" id="mailModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Send Mail</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        <form id="ajaxEditForm" class="" action="<?php echo e(route('admin.orders.mail')); ?>" method="POST">
                          <?php echo csrf_field(); ?>
                          <div class="form-group">
                            <label for="">Client Mail **</label>
                            <input id="inemail" type="text" class="form-control" name="email" value="" placeholder="Enter email">
                            <p id="eerremail" class="mb-0 text-danger em"></p>
                          </div>
                          <div class="form-group">
                            <label for="">Subject **</label>
                            <input id="insubject" type="text" class="form-control" name="subject" value="" placeholder="Enter subject">
                            <p id="eerrsubject" class="mb-0 text-danger em"></p>
                          </div>
                          <div class="form-group">
                            <label for="">Message **</label>
                            <textarea id="inmessage" class="form-control summernote" name="message" placeholder="Enter message" data-height="150"></textarea>
                            <p id="eerrmessage" class="mb-0 text-danger em"></p>
                          </div>
                        </form>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button id="updateBtn" type="button" class="btn btn-primary">Send Mail</button>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <div class="card-footer">
          <div class="row">
            <div class="d-inline-block mx-auto">
              <?php echo e($orders->appends(['search' => request()->input('search')])->links()); ?>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/admin/product/order/index.blade.php ENDPATH**/ ?>