<?php $__env->startSection('pagename'); ?>
- <?php echo e(convertUtf8($portfolio->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$portfolio->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$portfolio->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bs->portfolio_details_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($portfolio->title)); ?>
<?php $__env->startSection('breadcrumb-link', __('Portfolio Details')); ?>

<?php $__env->startSection('content'); ?>
<!--    case details section start   -->
<div class="case-details-section">
  <div class="container">
    <div class="row">
      <div class="col-lg-7 col-xl-7">
        <div class="project-ss-carousel owl-carousel owl-theme common-carousel">
          <?php $__currentLoopData = $portfolio->portfolio_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <a href="#" class="single-ss" data-id="<?php echo e($pi->id); ?>">
            <img class="lazy" data-src="<?php echo e(asset('assets/front/img/portfolios/sliders/'.$pi->image)); ?>" alt="">
          </a>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php $__currentLoopData = $portfolio->portfolio_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a id="singleMagnificSs<?php echo e($pi->id); ?>" class="single-magnific-ss d-none"
          href="<?php echo e(asset('assets/front/img/portfolios/sliders/'.$pi->image)); ?>"></a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="case-details">
          <?php echo replaceBaseUrl(convertUtf8($portfolio->content)); ?>

        </div>
      </div>
      <!--    appoint section start   -->
      <div class="col-lg-5 offset-xl-1 col-xl-4">
        <div class="right-side">
          <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12">
              <div class="project-infos">
                <h3><?php echo e(convertUtf8($portfolio->title)); ?></h3>
                <div class="row mb-2">
                  <div class="col-5 <?php echo e($rtl == 1 ? 'pl-0' : 'pr-0'); ?>"><strong><?php echo e(__('Client Name')); ?></strong></div>
                  <div class="col-7"><span>:</span> <?php echo e(convertUtf8($portfolio->client_name)); ?></div>
                </div>
                <div class="row mb-2">
                  <div class="col-5 <?php echo e($rtl == 1 ? 'pl-0' : 'pr-0'); ?>"><strong><?php echo e(__('Service')); ?></strong></div>
                  <?php if(!empty($portfolio->service->title)): ?>
                  <div class="col-7"><span>:</span> <?php echo e(convertUtf8($portfolio->service->title)); ?></div>
                  <?php endif; ?>
                </div>

                <?php if($portfolio->start_date != null): ?>
                  <?php
                    $startDate = Carbon\Carbon::parse($portfolio->start_date);
                  ?>
                  <div class="row mb-2">
                    <div class="col-5 <?php echo e($rtl == 1 ? 'pl-0' : 'pr-0'); ?>"><strong><?php echo e(__('Start Date')); ?></strong></div>
                    <div class="col-7"><span>:</span> <?php echo e(date_format($startDate, 'M d, Y')); ?></div>
                  </div>
                <?php endif; ?>

                <?php if($portfolio->submission_date != null): ?>
                  <?php
                    $submissionDate = Carbon\Carbon::parse($portfolio->submission_date);
                  ?>
                  <div class="row mb-2">
                    <div class="col-5 <?php echo e($rtl == 1 ? 'pl-0' : 'pr-0'); ?>"><strong><?php echo e(__('End Date')); ?></strong></div>
                    <div class="col-7"><span>:</span> <?php echo e(date_format($submissionDate, 'M d, Y')); ?></div>
                  </div>
                <?php endif; ?>

                <div class="row <?php echo e($portfolio->website_link != null ? 'mb-2' : 'mb-0'); ?>">
                  <div class="col-5 <?php echo e($rtl == 1 ? 'pl-0' : 'pr-0'); ?>"><strong><?php echo e(__('Status')); ?></strong></div>
                  <div class="col-7"><span>:</span> <?php echo e($portfolio->status); ?></div>
                </div>

                <?php if($portfolio->website_link != null): ?>
                  <div class="row mb-0">
                    <div class="col-12">
                        <a href="<?php echo e($portfolio->website_link); ?>" class="btn base-bg text-white btn-sm" target="_blank"><?php echo e(__('Live Demo')); ?></a>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
              <div class="subscribe-section">
                <span><?php echo e(__('SUBSCRIBE')); ?></span>
                <h3><?php echo e(__('SUBSCRIBE FOR NEWSLETTER')); ?></h3>
                <form id="subscribeForm" class="subscribe-form" action="<?php echo e(route('front.subscribe')); ?>" method="POST">
                  <?php echo csrf_field(); ?>
                  <div class="form-element"><input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>"></div>
                  <p id="erremail" class="text-danger mb-3 err-email"></p>
                  <div class="form-element"><input type="submit" value="<?php echo e(__('Subscribe')); ?>"></div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--    appoint section end   -->
    </div>
  </div>
</div>
<!--    case details section end   -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/portfolio-details.blade.php ENDPATH**/ ?>