<?php $__env->startSection('pagename'); ?>
 -
 <?php if(empty($category)): ?>
 <?php echo e(__('All')); ?>

 <?php else: ?>
 <?php echo e(convertUtf8($category->name)); ?>

 <?php endif; ?>
 <?php echo e(__('Jobs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->career_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->career_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($be->career_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($be->career_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Career')); ?>

<?php $__env->startSection('content'); ?>

  <!--    job lists start   -->
  <div class="job-lists">
     <div class="container">
        <div class="row">
           <div class="col-lg-8">
              <div class="row">
                <?php if(count($jobs) == 0): ?>
                  <div class="col-12 bg-light py-5">
                    <h3 class="text-center"><?php echo e(__('NO JOB FOUND')); ?></h3>
                  </div>
                <?php else: ?>
                  <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-12">
                       <div class="single-job <?php if($loop->last): ?> mb-0 <?php endif; ?>">

                            <h3><a href="<?php echo e(route('front.careerdetails', [$job->slug])); ?>" class="title"><?php echo e(convertUtf8($job->title)); ?></a></h3>

                            <?php
                            $deadline = \Carbon\Carbon::parse($job->deadline)->locale("$currentLang->code");
                            $deadline = $deadline->translatedFormat('jS F, Y');
                            ?>

                            <p class="deadline"><strong><i class="far fa-calendar-alt"></i> <?php echo e(__('Deadline')); ?>:</strong> <?php echo e($deadline); ?></p>
                            <p class="education"><strong><i class="fas fa-graduation-cap"></i> <?php echo e(__('Educational Experience')); ?>:</strong> <?php echo (strlen(strip_tags($job->educational_requirements)) > 110) ? mb_substr(strip_tags($job->educational_requirements), 0, 110, 'utf-8') . '...' : strip_tags($job->educational_requirements); ?></p>
                            <p class="experience"><strong><i class="fas fa-briefcase"></i> <?php echo e(__('Work Experience')); ?>:</strong> <?php echo e($job->experience); ?></p>
                       </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
              </div>
              <div class="row">
                <div class="col-md-12">
                   <nav class="pagination-nav">
                     <?php echo e($jobs->appends(['category' => request()->input('category'), 'term' => request()->input('term')])->links()); ?>

                   </nav>
                </div>
              </div>
           </div>
           <!--    job sidebar start   -->
           <div class="col-lg-4">
             <div class="blog-sidebar-widgets">
                <div class="searchbar-form-section">
                   <form action="<?php echo e(route('front.career')); ?>">
                      <div class="searchbar">
                         <input name="category" type="hidden" value="<?php echo e(request()->input('category')); ?>">
                         <input name="term" type="text" placeholder="<?php echo e(__('Search Jobs')); ?>" value="<?php echo e(request()->input('term')); ?>">
                         <button type="submit"><i class="fa fa-search"></i></button>
                      </div>
                   </form>
                </div>
             </div>
             <div class="blog-sidebar-widgets category-widget">
                <div class="category-lists job">
                   <h4><?php echo e(__('Job Categories')); ?></h4>
                   <ul>
                        <li class="single-category <?php echo e(empty(request()->input('category')) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('front.career')); ?>"><?php echo e(__('All')); ?> <span>(<?php echo e($jobscount); ?>)</span></a>
                        </li>
                        <?php $__currentLoopData = $jcats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $jcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="single-category <?php echo e($jcat->id == request()->input('category') ? 'active' : ''); ?>"><a href="<?php echo e(route('front.career', ['category' => $jcat->id, 'term'=>request()->input('term')])); ?>"><?php echo e(convertUtf8($jcat->name)); ?> <span>(<?php echo e($jcat->jobs()->count()); ?>)</span></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </ul>
                </div>
             </div>
           </div>
           <!--    job sidebar end   -->
        </div>
     </div>
  </div>
  <!--    job lists end   -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/career.blade.php ENDPATH**/ ?>