<?php $__env->startSection('styles'); ?>
  <style>
    input {
      margin-bottom: 10px;
    }

    .anonymous_user {
      font-size: 14px;
      text-align: center;
      margin-top: 20px;
    }

    .anonymous_user input {
      height: 14px;
      width: 14px;
      margin-right: 5px;
    }

    #stripe-section,
    #razorpay-section,
    #payumoney-section {
      margin-top: 10px;
    }

    .gateway-desc {
      background: #f1f1f1;
      font-size: 14px;
      padding: 10px 25px;
      margin-bottom: 20px;
      color: #212529;
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('Cause')); ?> - <?php echo e(convertUtf8($cause->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$cause->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$cause->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $bs->cause_details_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', strlen($cause->title) > 30 ? mb_substr($cause->title, 0, 30, 'utf-8') . '...' :
  $cause->title); ?>
<?php $__env->startSection('breadcrumb-link', $bs->cause_details_title); ?>

<?php $__env->startSection('content'); ?>
  <!--====== Start charity-causes Section ======-->
  <section class="single-causes-section">
    <div class="container">
      <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($error); ?></strong>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
      <div class="row">
        <div class="col-lg-8">
          <div class="causes-single-wrapper">
            <div class="causes-img">
              <?php if(!empty($cause->image)): ?>
                <img class="lazy" data-src="<?php echo e(asset('/assets/front/img/donations/' . $cause->image)); ?>"
                  alt="Cause Details">
              <?php endif; ?>
            </div>
            <div class="causes-content">
              <div class="single-progress-bar">
                <div class="progress-bar-inner" data-aos="fade-right"
                  style="width: <?php echo e($cause->goal_percentage == 0 ? 2 : $cause->goal_percentage); ?>%">
                  <div class="progress-bar-style"><?php echo e($cause->goal_percentage); ?>%</div>
                </div>
              </div>
              <div class="content-info pt-20">
                <h3><a><?php echo e(convertUtf8($cause->title)); ?></a></h3>
                <div class="causes-meta">
                  <p>
                    <span><?php echo e(__('Goal')); ?></span>-<?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($cause->goal_amount); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                  </p>
                  <p>
                    <span><?php echo e(__('Raised')); ?></span>-
                    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($cause->raised_amount); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                  </p>
                </div>
                <p><?php echo replaceBaseUrl(convertUtf8($cause->content)); ?></p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="charity-sidebar">
            <div class="widget-box donation-box">
              <div class="donation-form">
                <?php if($bex->donation_guest_checkout == 1 && !Auth::check()): ?>
                  <div class="alert alert-warning">
                    <?php echo e(__('You are now donating as a guest. If you want to login before donating, then please')); ?> <a
                      href="<?php echo e(route('user.login', ['redirected' => 'donation'])); ?>"><?php echo e(__('Click Here')); ?></a>
                  </div>
                <?php endif; ?>
                <h4 class="widget-title"><?php echo e(__('Donation Form')); ?></h4>
                <form action="<?php echo e(route('front.causes.payment')); ?>" method="post" enctype="multipart/form-data"
                  id="donationForm">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="donation_id" value="<?php echo e($cause->id); ?>" />
                  <input type="hidden" name="donation_slug" value="<?php echo e($cause->slug); ?>" />
                  <div id="donation-section">
                    <div class="form_group">
                      <input type="number" class="form_control amount_input" name="amount"
                        min="<?php echo e($cause->min_amount); ?>" value="<?php echo e($cause->min_amount); ?>" id="custom_amount">
                      <span><?php echo e($bex->base_currency_symbol); ?></span>
                    </div>

                    <?php if(!empty($cause->custom_amount)): ?>
                      <ul>
                        <?php $__currentLoopData = $custom_amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li style="margin-bottom: 20px;"><a href="javascript:void(0)"
                              onclick="rmvdbimg(<?php echo e($cause->min_amount); ?>,<?php echo e($custom_amount); ?>)"><?php echo e($custom_amount); ?></a>
                          </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    <?php endif; ?>

                    <?php
                      if (Auth::check()) {
                          $name = Auth::user()->fname;
                          $email = Auth::user()->email;
                          $phone = Auth::user()->number;
                      } else {
                          $name = '';
                          $email = '';
                          $phone = '';
                      }
                    ?>
                    <div id="donation-info-section">
                      <input type="hidden" name="minimum_amount" value="<?php echo e($cause->min_amount); ?>">
                      <input type="text" class="form_control" name="name" placeholder="<?php echo e(__('Enter your name')); ?>"
                        value="<?php echo e($name); ?>">
                      <input type="email" class="form_control" name="email"
                        placeholder="<?php echo e(__('Enter your email address')); ?>" value="<?php echo e($email); ?>">
                      <input type="text" class="form_control" name="phone"
                        placeholder="<?php echo e(__('Enter your phone')); ?>" value="<?php echo e($phone); ?>">
                    </div>
                  </div>

                  <select class="form-control" name="payment_method" id="payment-gateway" style="margin-bottom: 20px;"
                    required>
                    <option value="0"><?php echo e(__('Choose an option')); ?></option>
                    <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($payment_gateway->name); ?>"><?php echo e($payment_gateway->name); ?>

                      </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <div id="paystack-section" style="display: none">
                    <input type="text" class="form_control" name="paystack_email"
                      placeholder="<?php echo e(__('Email Address')); ?>">
                  </div>
                  <div id="flutterwave-section" style="display: none">
                    <input type="text" class="form_control" name="flutterwave_email"
                      placeholder="<?php echo e(__('Email Address')); ?>">
                  </div>
                  <div id="stripe-section" style="display: none">
                    <div id="stripe-element">
                      <!-- A Stripe Element will be inserted here. -->
                    </div>
                    <!-- Used to display form errors -->
                    <div id="stripe-errors" class="pb-2 text-danger text-left" role="alert"></div>
                  </div>
                  <div id="razorpay-section" style="display: none">
                    <input type="text" class="form_control" name="razorpay_phone"
                      placeholder="<?php echo e(__('Enter your phone')); ?>">
                    <input type="text" class="form_control" name="razorpay_address"
                      placeholder="<?php echo e('Enter your address'); ?>">
                  </div>
                  <div id="instructions">

                  </div>
                  <input type="hidden" name="is_receipt" value="0" id="is_receipt">
                  <div class="anonymous_user">
                    <input type="checkbox" class="form_control" name="checkbox">
                    <?php echo e(__('Anonymous Donation')); ?>

                  </div>
                  <button type="submit" class="main-btn"
                    style="text-align: center; margin-top: 20px;"><?php echo e(__('Donate Now')); ?>

                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    let stripe_key = "<?php echo e($stripe_key); ?>";
  </script>
  <script src="https://js.stripe.com/v3/"></script>
  <script src="<?php echo e(asset('assets/front/js/donation-checkout-stripe.js')); ?>"></script>
  <script>
    function rmvdbimg(min, amount) {
      $("#custom_amount").val(amount);
    }

    function infoSectionToggle() {
      let selectedPaymentMethod = $("#payment-gateway").children("option:selected").val();
      if ($('input[type="checkbox"]:checked').length > 0 && selectedPaymentMethod != 'PayUmoney') {
        $('#donation-info-section').fadeOut();
      } else {
        $('#donation-info-section').fadeIn(5);
      }
    }

    $(document).ready(function() {
      $('input[type="checkbox"]').click(function() {
        var selectedPaymentMethod = $("#payment-gateway").children("option:selected").val();

        if ($(this).prop("checked") == true) {
          if (selectedPaymentMethod != "PayUmoney") {
            $('#donation-info-section').fadeOut();
          }
          if (selectedPaymentMethod == "Paystack") {
            $('#stripe-section').fadeOut();
            $('#instructions').fadeOut();
            $('#razorpay-section').fadeOut();
            $('#flutterwave-section').fadeOut();
            $('#paystack-section').fadeIn(5);
          } else if (selectedPaymentMethod == "Flutterwave") {
            $('#stripe-section').fadeOut();
            $('#instructions').fadeOut();
            $('#razorpay-section').fadeOut();
            $('#paystack-section').fadeOut();
            $('#flutterwave-section').fadeIn(5);
          }
        } else if ($(this).prop("checked") == false) {
          $('#donation-info-section').fadeIn(5);
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
        }
      });
      $("#payment-gateway").change(function() {
        var selectedPaymentMethod = $(this).children("option:selected").val();
        let offline = <?php echo $offline; ?>;
        let data = [];
        offline.map(({
          id,
          name
        }) => {
          data.push(name);
        });
        $('#instructions').fadeOut();
        infoSectionToggle();
        if (selectedPaymentMethod == "Stripe") {
          $('#razorpay-section').fadeOut();
          $('#instructions').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          $('#stripe-section').fadeIn(5);
        } else if (selectedPaymentMethod == "Razorpay") {
          $('#stripe-section').fadeOut();
          $('#instructions').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          $('#razorpay-section').fadeIn(5);
        } else if (selectedPaymentMethod == "PayUmoney") {
          $('#stripe-section').fadeOut();
          $('#instructions').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          $('#razorpay-section').fadeOut(5);
        } else if (selectedPaymentMethod == "Paystack" && $("input[name='checkbox']:checked").length > 0) {
          $('#stripe-section').fadeOut();
          $('#instructions').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          $('#paystack-section').fadeIn(5);
        } else if (selectedPaymentMethod == "Flutterwave" && $("input[name='checkbox']:checked").length > 0) {
          $('#stripe-section').fadeOut();
          $('#instructions').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeIn(5);
        } else if (data.indexOf(selectedPaymentMethod) !== -1) {
          $('#stripe-section').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          //ajax call for instructions
          let name = selectedPaymentMethod;
          let formData = new FormData();
          formData.append('name', name);
          $.ajax({
            url: '<?php echo e(route('front.payment.instructions')); ?>',
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            contentType: false,
            processData: false,
            cache: false,
            data: formData,
            success: function(data) {
              console.log(data);
              let instruction = $("#instructions");
              let instructions = `<div class="gateway-desc">${data.instructions}</div>`;
              let description = `<div class="gateway-desc"><p>${data.description}</p></div>`;
              let receipt = `<div class="form-element mb-2">
                                              <label>Receipt  <span>**</span> </label>
                                              <input type="file" name="receipt" value="" class="file-input">
                                              <p class="mb-0 text-warning">** Receipt image must be .jpg / .jpeg / .png</p>
                                           </div>`;
              if (data.is_receipt === 1) {
                $("#is_receipt").val(1);
                let finalInstruction = instructions + description + receipt;
                instruction.html(finalInstruction);
              } else {
                $("#is_receipt").val(0);
                let finalInstruction = instructions + description;
                instruction.html(finalInstruction);
              }
              $('#instructions').fadeIn();
            },
            error: function(data) {
              console.log(data);
            }
          })
        } else {
          $('#stripe-section').fadeOut();
          $('#razorpay-section').fadeOut();
          $('#paystack-section').fadeOut();
          $('#flutterwave-section').fadeOut();
          $('#instructions').fadeOut();
        }
      });

    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/cause-details.blade.php ENDPATH**/ ?>