<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('All Articles')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bex->knowledgebase_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($bse->knowledgebase_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Knowledgebase')); ?>

<?php $__env->startSection('content'); ?>

  
  <section class="knowledge-list-section">
    <div class="container">
      <div class="row">
        <?php if(count($article_categories) == 0): ?>
          <div class="col-md-12">
            <div class="bg-light py-5">
              <h3 class="text-center"><?php echo e(__('NO ARTICLE FOUND')); ?></h3>
            </div>
          </div>
        <?php else: ?>
          <?php $__currentLoopData = $article_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 col-sm-12">
              <div class="knowledge-box mb-40">
                <div class="title">
                  <h3><a href="#"><?php echo e($article_category->name); ?></a></h3>
                </div>
                <?php
                $articles = App\Article::where('article_category_id', $article_category->id)
                  ->orderBy('id', 'desc')
                  ->get();
                $count = 0;
                ?>
                <ul class="list">
                  <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a href="<?php echo e(route('front.knowledgebase_details', ['slug' => $article->slug])); ?>">
                        <?php echo e(strlen($article->title) > 30 ? mb_substr($article->title,0,30,'utf-8') . '...' : $article->title); ?>

                    </a></li>
                    <?php $count = $count + 1; ?>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <a
                  class="btn_link"
                ><?php echo e($count . ' ' . __('Articles in this category')); ?></a>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </div>
    </div>
  </section>
  
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/articles.blade.php ENDPATH**/ ?>