<?php
$default = \App\Language::where('is_default', 1)->first();
$admin = Auth::guard('admin')->user();
if (!empty($admin->role)) {
    $permissions = $admin->role->permissions;
    $permissions = json_decode($permissions, true);
}

$data = \App\BasicExtra::first();
?>

<div class="sidebar sidebar-style-2" data-background-color="dark2">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    <?php if(!empty(Auth::guard('admin')->user()->image)): ?>
                    <img src="<?php echo e(asset('assets/admin/img/propics/'.Auth::guard('admin')->user()->image)); ?>" alt="..."
                    class="avatar-img rounded">
                    <?php else: ?>
                    <img src="<?php echo e(asset('assets/admin/img/propics/blank_user.jpg')); ?>" alt="..." class="avatar-img rounded">
                    <?php endif; ?>
                </div>
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true">
                        <span>
                            <?php echo e(Auth::guard('admin')->user()->first_name); ?>

                            <?php if(empty(Auth::guard('admin')->user()->role)): ?>
                            <span class="user-level">Owner</span>
                            <?php else: ?>
                            <span class="user-level"><?php echo e(Auth::guard('admin')->user()->role->name); ?></span>
                            <?php endif; ?>
                            <span class="caret"></span>
                        </span>
                    </a>
                    <div class="clearfix"></div>
                    <div class="collapse in" id="collapseExample">
                        <ul class="nav">
                            <li>
                                <a href="<?php echo e(route('admin.editProfile')); ?>">
                                    <span class="link-collapse">Edit Profile</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.changePass')); ?>">
                                    <span class="link-collapse">Change Password</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.logout')); ?>">
                                    <span class="link-collapse">Logout</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <ul class="nav nav-primary mt-0">
                <div class="row mb-2">
                    <div class="col-12">
                        <form action="">
                            <div class="form-group py-0">
                                <input name="term" type="text" class="form-control sidebar-search" value="" placeholder="Search Menu Here...">
                            </div>
                        </form>
                    </div>
                </div>

                <?php if(empty($admin->role) || (!empty($permissions) && in_array('Dashboard', $permissions))): ?>
                
                <li class="nav-item <?php if(request()->path() == 'admin/dashboard'): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.dashboard')); ?>">
                        <i class="la flaticon-paint-palette"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <?php endif; ?>


                <?php if(empty($admin->role) || (!empty($permissions) && in_array('Theme & Home', $permissions))): ?>
                
                <li class="nav-item
                <?php if(request()->path() == 'admin/home-settings'): ?> active
                <?php elseif(request()->path() == 'admin/home-page'): ?> active
                <?php endif; ?>">
                <a data-toggle="collapse" href="#themeHome">
                    <i class="la flaticon-file"></i>
                    <p>Theme & Home
                        <?php if($bex->home_page_pagebuilder == 1): ?>
                        <span class="badge badge-danger p-1 sidenav-badge">Pagebuilder</span>
                        <?php endif; ?>
                    </p>
                    <span class="caret"></span>
                </a>
                <div class="collapse
                <?php if(request()->path() == 'admin/home-settings'): ?> show
                <?php elseif(request()->path() == 'admin/home-page'): ?> show
                <?php endif; ?>" id="themeHome">
                <ul class="nav nav-collapse">
                    <li class="<?php if(request()->path() == 'admin/home-settings'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.homeSettings')); ?>">
                            <span class="sub-item">Settings</span>
                        </a>
                    </li>
                    <?php if($bex->home_page_pagebuilder == 1): ?>

                    <li class="<?php if(request()->path() == 'admin/home-page'): ?> active <?php endif; ?>">
                        <a href="#" data-toggle="modal" data-target="#pbLangModal">
                            <span class="sub-item">Home Page Content</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
        <?php endif; ?>


        <?php if(empty($admin->role) || (!empty($permissions) && in_array('Menu Builder', $permissions))): ?>
        
        <li class="nav-item
        <?php if(request()->path() == 'admin/menu-builder'): ?> active
        <?php elseif(request()->path() == 'admin/megamenus'): ?> active
        <?php elseif(request()->path() == 'admin/megamenus/edit'): ?> active
        <?php elseif(request()->path() == 'admin/permalinks'): ?> active
        <?php endif; ?>">
        <a data-toggle="collapse" href="#websiteMenu">
            <i class="fas fa-ellipsis-v"></i>
            <p>Website Menu Builder</p>
            <span class="caret"></span>
        </a>
        <div class="collapse
        <?php if(request()->path() == 'admin/menu-builder'): ?> show
        <?php elseif(request()->path() == 'admin/megamenus'): ?> show
        <?php elseif(request()->path() == 'admin/permalinks'): ?> show
        <?php elseif(request()->path() == 'admin/megamenus/edit'): ?> show
        <?php endif; ?>" id="websiteMenu">
        <ul class="nav nav-collapse">
            <li class="<?php if(request()->path() == 'admin/megamenus'): ?> active
                <?php elseif(request()->path() == 'admin/megamenus/edit'): ?> active
                <?php endif; ?>">
                <a href="<?php echo e(route('admin.megamenus') . '?language=' . $default->code); ?>">
                    <span class="sub-item">Mega Menus</span>
                </a>
            </li>
            <li class="<?php if(request()->path() == 'admin/menu-builder'): ?> active <?php endif; ?>">
                <a href="<?php echo e(route('admin.menu_builder.index') . '?language=' . $default->code); ?>">
                    <span class="sub-item">Main Menu</span>
                </a>
            </li>
            <li class="<?php if(request()->path() == 'admin/permalinks'): ?> active <?php endif; ?>">
                <a href="<?php echo e(route('admin.permalinks.index')); ?>">
                    <span class="sub-item">Permalinks</span>
                </a>
            </li>
        </ul>
    </div>
</li>
<?php endif; ?>




<?php if(empty($admin->role) || (!empty($permissions) && in_array('Content Management', $permissions))): ?>
<?php if ($__env->exists('admin.partials.content-management')) echo $__env->make('admin.partials.content-management', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>


<?php if(empty($admin->role) || (!empty($permissions) && in_array('Pages', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/page/create'): ?> active
<?php elseif(request()->path() == 'admin/page/settings'): ?> active
<?php elseif(request()->path() == 'admin/pages'): ?> active
<?php elseif(request()->is('admin/page/*/edit')): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#pages">
    <i class="la flaticon-file"></i>
    <p>Custom Pages <span class="badge badge-danger p-1 sidenav-badge">Pagebuilder</span></p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/page/create'): ?> show
<?php elseif(request()->path() == 'admin/page/settings'): ?> show
<?php elseif(request()->path() == 'admin/pages'): ?> show
<?php elseif(request()->is('admin/page/*/edit')): ?> show
<?php endif; ?>" id="pages">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/page/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.page.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/page/create'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.page.create') . '?language=' . $default->code); ?>">
            <span class="sub-item">Create Page</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/pages'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.page.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Pages</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Event Calendar', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/calendars'): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.calendar.index') . '?language=' . $default->code); ?>">
    <i class="la flaticon-calendar"></i>
    <p>Event Calendar</p>
</a>
</li>
<?php endif; ?>



<?php if(empty($admin->role) || (!empty($permissions) && in_array('Package Management', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/packages'): ?> active
<?php elseif(request()->routeIs('admin.package.edit')): ?> active
<?php elseif(request()->path() == 'admin/package/form'): ?> active
<?php elseif(request()->is('admin/package/*/inputEdit')): ?> active
<?php elseif(request()->path() == 'admin/all/orders'): ?> active
<?php elseif(request()->path() == 'admin/pending/orders'): ?> active
<?php elseif(request()->path() == 'admin/processing/orders'): ?> active
<?php elseif(request()->path() == 'admin/completed/orders'): ?> active
<?php elseif(request()->path() == 'admin/rejected/orders'): ?> active
<?php elseif(request()->path() == 'admin/package/settings'): ?> active
<?php elseif(request()->path() == 'admin/package/categories'): ?> active
<?php elseif(request()->routeIs('admin.subscriptions')): ?> active
<?php elseif(request()->path() == 'admin/package/order/report'): ?> active
<?php endif; ?>"
>
<a data-toggle="collapse" href="#packages">
    <i class="la flaticon-box-1"></i>
    <p>Package Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/packages'): ?> show
<?php elseif(request()->routeIs('admin.package.edit')): ?> show
<?php elseif(request()->path() == 'admin/package/form'): ?> show
<?php elseif(request()->is('admin/package/*/inputEdit')): ?> show
<?php elseif(request()->path() == 'admin/all/orders'): ?> show
<?php elseif(request()->path() == 'admin/pending/orders'): ?> show
<?php elseif(request()->path() == 'admin/processing/orders'): ?> show
<?php elseif(request()->path() == 'admin/completed/orders'): ?> show
<?php elseif(request()->path() == 'admin/rejected/orders'): ?> show
<?php elseif(request()->path() == 'admin/package/settings'): ?> show
<?php elseif(request()->path() == 'admin/package/categories'): ?> show
<?php elseif(request()->routeIs('admin.subscriptions')): ?> show
<?php elseif(request()->path() == 'admin/package/order/report'): ?> show
<?php endif; ?>" id="packages"
>
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/package/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.package.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <?php if($data->package_category_status == 1): ?>
    <li class="<?php if(request()->path() == 'admin/package/categories'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.package.categories') . '?language=' . $default->code); ?>">
            <span class="sub-item">Categories</span>
        </a>
    </li>
    <?php endif; ?>
    <li class="<?php if(request()->path() == 'admin/package/form'): ?> active
        <?php elseif(request()->is('admin/package/*/inputEdit')): ?> active
        <?php endif; ?>"
        >
        <a href="<?php echo e(route('admin.package.form') . '?language=' . $default->code); ?>">
            <span class="sub-item">Form Builder</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/packages'): ?> active
        <?php elseif(request()->routeIs('admin.package.edit')): ?> active
        <?php endif; ?>"
        >
        <a href="<?php echo e(route('admin.package.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Packages</span>
        </a>
    </li>
    <?php if($bex->recurring_billing == 1): ?>
    <li class="submenu">
        <a data-toggle="collapse" href="#manageSubscriptions"
        aria-expanded="<?php echo e(((request()->routeIs('admin.subscriptions') && request()->input('type') != 'request')) ? 'true' : 'false'); ?>">
        <span class="sub-item">Subscriptions</span>
        <span class="caret"></span>
    </a>
    <div class="collapse <?php if((request()->routeIs('admin.subscriptions') && request()->input('type') != 'request')): ?> show <?php endif; ?>" id="manageSubscriptions" style="">
        <ul class="nav nav-collapse subnav">
            <li class="<?php if(request()->routeIs('admin.subscriptions') && request()->input('type') == 'all'): ?> active <?php endif; ?>">
                <a href="<?php echo e(route('admin.subscriptions', ['type' => 'all'])); ?>">
                    <span class="sub-item">All Subscriptions</span>
                </a>
            </li>
            <li class="<?php if(request()->routeIs('admin.subscriptions') && request()->input('type') == 'active'): ?> active <?php endif; ?>">
                <a href="<?php echo e(route('admin.subscriptions', ['type' => 'active'])); ?>">
                    <span class="sub-item">Active Subscriptions</span>
                </a>
            </li>
            <li class="<?php if(request()->routeIs('admin.subscriptions') && request()->input('type') == 'expired'): ?> active <?php endif; ?>">
                <a href="<?php echo e(route('admin.subscriptions', ['type' => 'expired'])); ?>">
                    <span class="sub-item">Expired Subscriptions</span>
                </a>
            </li>
        </ul>
    </div>
</li>
<li class="<?php if(request()->routeIs('admin.subscriptions') && request()->input('type') == 'request'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.subscriptions', ['type' => 'request'])); ?>">
        <span class="sub-item">Subscription Requests</span>
    </a>
</li>
<?php endif; ?>
<?php if($bex->recurring_billing == 0): ?>
<li class="submenu">
    <a data-toggle="collapse" href="#packageOrders"
    aria-expanded="<?php echo e((request()->path() == 'admin/all/orders' || request()->path() == 'admin/pending/orders' || request()->path() == 'admin/processing/orders' || request()->path() == 'admin/completed/orders' || request()->path() == 'admin/rejected/orders' || request()->path() == 'admin/package/order/report') ? 'true' : 'false'); ?>">
    <span class="sub-item">Manage Orders</span>
    <span class="caret"></span>
</a>
<div class="collapse <?php echo e((request()->path() == 'admin/all/orders' || request()->path() == 'admin/pending/orders' || request()->path() == 'admin/processing/orders' || request()->path() == 'admin/completed/orders' || request()->path() == 'admin/package/order/report') ? 'show' : ''); ?>" id="packageOrders" style="">
    <ul class="nav nav-collapse subnav">
        <li class="<?php if(request()->path() == 'admin/all/orders'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.all.orders')); ?>">
                <span class="sub-item">All Orders</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/pending/orders'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.pending.orders')); ?>">
                <span class="sub-item">Pending Orders</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/processing/orders'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.processing.orders')); ?>">
                <span class="sub-item">Processing Orders</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/completed/orders'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.completed.orders')); ?>">
                <span class="sub-item">Completed Orders</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/rejected/orders'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.rejected.orders')); ?>">
                <span class="sub-item">Rejected Orders</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/package/order/report'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.package.report')); ?>">
                <span class="sub-item">Report</span>
            </a>
        </li>
    </ul>
</div>
</li>
<?php endif; ?>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Quote Management', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/quote/form'): ?> active
<?php elseif(request()->is('admin/quote/*/inputEdit')): ?> active
<?php elseif(request()->path() == 'admin/all/quotes'): ?> active
<?php elseif(request()->path() == 'admin/pending/quotes'): ?> active
<?php elseif(request()->path() == 'admin/processing/quotes'): ?> active
<?php elseif(request()->path() == 'admin/completed/quotes'): ?> active
<?php elseif(request()->path() == 'admin/rejected/quotes'): ?> active
<?php elseif(request()->path() == 'admin/quote/visibility'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#quote">
    <i class="la flaticon-list"></i>
    <p>Quote Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/quote/form'): ?> show
<?php elseif(request()->is('admin/quote/*/inputEdit')): ?> show
<?php elseif(request()->path() == 'admin/all/quotes'): ?> show
<?php elseif(request()->path() == 'admin/pending/quotes'): ?> show
<?php elseif(request()->path() == 'admin/processing/quotes'): ?> show
<?php elseif(request()->path() == 'admin/completed/quotes'): ?> show
<?php elseif(request()->path() == 'admin/rejected/quotes'): ?> show
<?php elseif(request()->path() == 'admin/quote/visibility'): ?> show
<?php endif; ?>" id="quote">
<ul class="nav nav-collapse">
    <li class="
    <?php if(request()->path() == 'admin/quote/visibility'): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.quote.visibility')); ?>">
        <span class="sub-item">Visibility</span>
    </a>
</li>
<li class="
<?php if(request()->path() == 'admin/quote/form'): ?> active
<?php elseif(request()->is('admin/quote/*/inputEdit')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.quote.form') . '?language=' . $default->code); ?>">
    <span class="sub-item">Form Builder</span>
</a>
</li>
<li class="<?php if(request()->path() == 'admin/all/quotes'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.all.quotes')); ?>">
        <span class="sub-item">All Quotes</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/pending/quotes'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.pending.quotes')); ?>">
        <span class="sub-item">Pending Quotes</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/processing/quotes'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.processing.quotes')); ?>">
        <span class="sub-item">Processing Quotes</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/completed/quotes'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.completed.quotes')); ?>">
        <span class="sub-item">Completed Quotes</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/rejected/quotes'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.rejected.quotes')); ?>">
        <span class="sub-item">Rejected Quotes</span>
    </a>
</li>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Shop Management', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/category'): ?> active
<?php elseif(request()->path() == 'admin/product'): ?> active
<?php elseif(request()->routeIs('admin.product.type')): ?> active
<?php elseif(request()->is('admin/product/*/edit')): ?> active
<?php elseif(request()->is('admin/category/*/edit')): ?> active
<?php elseif(request()->path() == 'admin/product/all/orders'): ?> active
<?php elseif(request()->path() == 'admin/product/pending/orders'): ?> active
<?php elseif(request()->path() == 'admin/product/processing/orders'): ?> active
<?php elseif(request()->path() == 'admin/product/completed/orders'): ?> active
<?php elseif(request()->path() == 'admin/product/rejected/orders'): ?> active
<?php elseif(request()->routeIs('admin.product.create')): ?> active
<?php elseif(request()->routeIs('admin.product.details')): ?> active
<?php elseif(request()->path() == 'admin/coupon'): ?> active
<?php elseif(request()->routeIs('admin.coupon.edit')): ?> active
<?php elseif(request()->path() == 'admin/shipping'): ?> active
<?php elseif(request()->routeIs('admin.shipping.edit')): ?> active
<?php elseif(request()->routeIs('admin.product.tags')): ?> active
<?php elseif(request()->routeIs('admin.product.settings')): ?> active
<?php elseif(request()->path() == 'admin/product/orders/report'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#category">
    <i class="fas fa-store-alt"></i>
    <p>Shop Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/category'): ?> show
<?php elseif(request()->is('admin/category/*/edit')): ?> show
<?php elseif(request()->routeIs('admin.product.type')): ?> show
<?php elseif(request()->path() == 'admin/product'): ?> show
<?php elseif(request()->is('admin/product/*/edit')): ?> show
<?php elseif(request()->path() == 'admin/product/all/orders'): ?> show
<?php elseif(request()->path() == 'admin/product/pending/orders'): ?> show
<?php elseif(request()->path() == 'admin/product/processing/orders'): ?> show
<?php elseif(request()->path() == 'admin/product/completed/orders'): ?> show
<?php elseif(request()->path() == 'admin/product/rejected/orders'): ?> show
<?php elseif(request()->routeIs('admin.product.create')): ?> show
<?php elseif(request()->routeIs('admin.product.details')): ?> show
<?php elseif(request()->path() == 'admin/coupon'): ?> show
<?php elseif(request()->routeIs('admin.coupon.edit')): ?> show
<?php elseif(request()->path() == 'admin/shipping'): ?> show
<?php elseif(request()->routeIs('admin.shipping.edit')): ?> show
<?php elseif(request()->routeIs('admin.product.tags')): ?> show
<?php elseif(request()->routeIs('admin.product.settings')): ?> show
<?php elseif(request()->path() == 'admin/product/orders/report'): ?> show
<?php endif; ?>" id="category">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->routeIs('admin.product.settings')): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.product.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->routeIs('admin.product.tags')): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.product.tags'). '?language=' . $default->code); ?>">
            <span class="sub-item">Popular Tags</span>
        </a>
    </li>

    <?php if($bex->catalog_mode == 0): ?>
    <li class="
    <?php if(request()->path() == 'admin/shipping'): ?> active
    <?php elseif(request()->routeIs('admin.shipping.edit')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.shipping.index'). '?language=' . $default->code); ?>">
        <span class="sub-item">Shipping Charges</span>
    </a>
</li>
<?php endif; ?>

<?php if($bex->catalog_mode == 0): ?>
<li class="
<?php if(request()->path() == 'admin/coupon'): ?> active
<?php elseif(request()->routeIs('admin.coupon.edit')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.coupon.index')); ?>">
    <span class="sub-item">Coupons</span>
</a>
</li>
<?php endif; ?>
<li class="submenu">
    <a data-toggle="collapse" href="#productManagement"
    aria-expanded="<?php echo e((request()->path() == 'admin/category' || request()->is('admin/category/*/edit') || request()->routeIs('admin.product.type') || request()->routeIs('admin.product.create') || request()->routeIs('admin.product.index') || request()->routeIs('admin.product.edit')) ? 'true' : 'false'); ?>">
    <span class="sub-item">Manage Products</span>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/category'): ?> show
<?php elseif(request()->is('admin/category/*/edit')): ?> show
<?php elseif(request()->routeIs('admin.product.type')): ?> show
<?php elseif(request()->routeIs('admin.product.create')): ?> show
<?php elseif(request()->routeIs('admin.product.index')): ?> show
<?php elseif(request()->routeIs('admin.product.edit')): ?> show
<?php endif; ?>" id="productManagement" style="">
<ul class="nav nav-collapse subnav">
    <li class="
    <?php if(request()->path() == 'admin/category'): ?> active
    <?php elseif(request()->is('admin/category/*/edit')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.category.index') . '?language=' . $default->code); ?>">
        <span class="sub-item">Category</span>
    </a>
</li>
<li class="
<?php if(request()->routeIs('admin.product.type')): ?> active
<?php elseif(request()->routeIs('admin.product.create')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.product.type')); ?>">
    <span class="sub-item">Add Product</span>
</a>
</li>
<li class="
<?php if(request()->path() == 'admin/product'): ?> active
<?php elseif(request()->is('admin/product/*/edit')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.product.index'). '?language=' . $default->code); ?>">
    <span class="sub-item">Products</span>
</a>
</li>
</ul>
</div>
</li>

<?php if($bex->catalog_mode == 0): ?>
<li class="submenu">
    <a data-toggle="collapse" href="#manageOrders"
    aria-expanded="<?php echo e((request()->routeIs('admin.all.product.orders') || request()->routeIs('admin.pending.product.orders') || request()->routeIs('admin.processing.product.orders') || request()->routeIs('admin.completed.product.orders') || request()->routeIs('admin.rejected.product.orders') || request()->routeIs('admin.product.details') || (request()->path() == 'admin/product/orders/report')) ? 'true' : 'false'); ?>">
    <span class="sub-item">Manage Orders</span>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->routeIs('admin.all.product.orders')): ?> show
<?php elseif(request()->routeIs('admin.pending.product.orders')): ?> show
<?php elseif(request()->routeIs('admin.processing.product.orders')): ?> show
<?php elseif(request()->routeIs('admin.completed.product.orders')): ?> show
<?php elseif(request()->routeIs('admin.rejected.product.orders')): ?> show
<?php elseif(request()->routeIs('admin.product.details')): ?> show
<?php elseif(request()->path() == 'admin/product/orders/report'): ?> show
<?php endif; ?>" id="manageOrders" style="">
<ul class="nav nav-collapse subnav">
    <li class="<?php if(request()->path() == 'admin/product/all/orders'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.all.product.orders')); ?>">
            <span class="sub-item">All Orders</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/product/pending/orders'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.pending.product.orders')); ?>">
            <span class="sub-item">Pending Orders</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/product/processing/orders'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.processing.product.orders')); ?>">
            <span class="sub-item">Processing Orders</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/product/completed/orders'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.completed.product.orders')); ?>">
            <span class="sub-item">Completed Orders</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/product/rejected/orders'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.rejected.product.orders')); ?>">
            <span class="sub-item">Rejected Orders</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/product/orders/report'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.orders.report')); ?>">
            <span class="sub-item">Report</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Course Management', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/course_categories'): ?> active
<?php elseif(request()->path() == 'admin/course/settings'): ?> active
<?php elseif(request()->path() == 'admin/course/purchase-log'): ?> active
<?php elseif(request()->path() == 'admin/courses'): ?> active
<?php elseif(request()->path() == 'admin/course/create'): ?> active
<?php elseif(request()->is('admin/course/*/edit')): ?> active
<?php elseif(request()->is('admin/course/*/modules')): ?> active
<?php elseif(request()->is('admin/module/*/lessons')): ?> active
<?php elseif(request()->path() == 'admin/course/enrolls/report'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#course">
    <i class='fas fa-book-open'></i>
    <p>Course Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/course_categories'): ?> show
<?php elseif(request()->path() == 'admin/course/settings'): ?> show
<?php elseif(request()->path() == 'admin/course/purchase-log'): ?> show
<?php elseif(request()->path() == 'admin/courses'): ?> show
<?php elseif(request()->path() == 'admin/course/create'): ?> show
<?php elseif(request()->is('admin/course/*/edit')): ?> show
<?php elseif(request()->is('admin/course/*/modules')): ?> show
<?php elseif(request()->is('admin/module/*/lessons')): ?> show
<?php elseif(request()->path() == 'admin/course/enrolls/report'): ?> show
<?php endif; ?>"
id="course"
>
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/course/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.course.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/course_categories'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.course_category.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Category</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/course/create'): ?> active
        <?php endif; ?>">
        <a href="<?php echo e(route('admin.course.create') . '?language=' . $default->code); ?>">
            <span class="sub-item">Add Course</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/courses'): ?> active
        <?php elseif(request()->is('admin/course/*/edit')): ?> active
        <?php elseif(request()->is('admin/course/*/modules')): ?> active
        <?php elseif(request()->is('admin/module/*/lessons')): ?> active
        <?php endif; ?>">
        <a href="<?php echo e(route('admin.course.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Courses</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/course/purchase-log'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.course.purchaseLog')); ?>">
            <span class="sub-item">Enrolls</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/course/enrolls/report'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.enrolls.report')); ?>">
            <span class="sub-item">Report</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>




<?php if(empty($admin->role) || (!empty($permissions) && in_array('Events Management', $permissions))): ?>
<li class="nav-item
<?php if(request()->path() == 'admin/event/categories'): ?> active
<?php elseif(request()->path() == 'admin/event/settings'): ?> active
<?php elseif(request()->path() == 'admin/events'): ?> active
<?php elseif(request()->path() == 'admin/events/payment-log'): ?> active
<?php elseif(request()->is('admin/event/*/edit')): ?> active
<?php elseif(request()->path() == 'admin/events/report'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#event_manage">
    <i class="fas fa-calendar-alt"></i>
    <p>Events Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/event/categories'): ?> show
<?php elseif(request()->path() == 'admin/event/settings'): ?> show
<?php elseif(request()->path() == 'admin/events'): ?> show
<?php elseif(request()->path() == 'admin/events/payment-log'): ?> show
<?php elseif(request()->is('admin/event/*/edit')): ?> show
<?php elseif(request()->path() == 'admin/events/report'): ?> show
<?php endif; ?>" id="event_manage">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/event/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.event.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/event/categories'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.event.category.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Category</span>
        </a>
    </li>
    <li class="
    <?php if(request()->path() == 'admin/events'): ?> active
    <?php elseif(request()->is('admin/event/*/edit')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.event.index') . '?language=' . $default->code); ?>">
        <span class="sub-item">All Events</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/events/payment-log'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.event.payment.log') . '?language=' . $default->code); ?>">
        <span class="sub-item">Bookings</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/events/report'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.event.report')); ?>">
        <span class="sub-item">Report</span>
    </a>
</li>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Donation Management', $permissions))): ?>
<li class="nav-item
<?php if(request()->path() == 'admin/donations'): ?> active
<?php elseif(request()->path() == 'admin/donations/payment-log'): ?> active
<?php elseif(request()->path() == 'admin/donation/settings'): ?> active
<?php elseif(request()->is('admin/donation/*/edit')): ?> active
<?php elseif(request()->path() == 'admin/donation/report'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#donation_manage">
    <i class="fas fa-hand-holding-usd"></i>
    <p>Donations & Causes</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/donations'): ?> show
<?php elseif(request()->path() == 'admin/donations/payment-log'): ?> show
<?php elseif(request()->is('admin/donation/*/edit')): ?> show
<?php elseif(request()->path() == 'admin/donation/settings'): ?> show
<?php elseif(request()->path() == 'admin/donation/report'): ?> show
<?php endif; ?>" id="donation_manage">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/donation/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.donation.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="
    <?php if(request()->path() == 'admin/donations'): ?> active
    <?php elseif(request()->is('admin/donation/*/edit')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.donation.index') . '?language=' . $default->code); ?>">
        <span class="sub-item">All Causes</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/donations/payment-log'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.donation.payment.log') . '?language=' . $default->code); ?>">
        <span class="sub-item">Donations</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/donation/report'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.donation.report')); ?>">
        <span class="sub-item">Report</span>
    </a>
</li>
</ul>
</div>
</li>
<?php endif; ?>


<?php if(empty($admin->role) || (!empty($permissions) && in_array('Knowledgebase', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/article_categories'): ?> active
<?php elseif(request()->path() == 'admin/articles'): ?> active
<?php elseif(request()->path() == 'admin/article/archives'): ?> active
<?php elseif(request()->is('admin/article/*/edit')): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#article">
    <i class='fas fa-pencil-alt'></i>
    <p>Knowledgebase</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/article_categories'): ?> show
<?php elseif(request()->path() == 'admin/articles'): ?> show
<?php elseif(request()->path() == 'admin/article/archives'): ?> show
<?php elseif(request()->is('admin/article/*/edit')): ?> show
<?php endif; ?>" id="article">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/article_categories'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.article_category.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Category</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/articles'): ?> active
        <?php elseif(request()->is('admin/articles/*/edit')): ?> active
        <?php endif; ?>">
        <a href="<?php echo e(route('admin.article.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Articles</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>

<?php if(empty($admin->role) || (!empty($permissions) && in_array('Tickets', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/all/tickets'): ?> active
<?php elseif(request()->path() == 'admin/pending/tickets'): ?> active
<?php elseif(request()->path() == 'admin/open/tickets'): ?> active
<?php elseif(request()->path() == 'admin/closed/tickets'): ?> active
<?php elseif(request()->routeIs('admin.ticket.messages')): ?> active
<?php elseif(request()->routeIs('admin.ticket.settings')): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#tickets">
    <i class="la flaticon-web-1"></i>
    <p>Support Tickets</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/all/tickets'): ?> show
<?php elseif(request()->path() == 'admin/pending/tickets'): ?> show
<?php elseif(request()->path() == 'admin/open/tickets'): ?> show
<?php elseif(request()->path() == 'admin/closed/tickets'): ?> show
<?php elseif(request()->routeIs('admin.ticket.messages')): ?> show
<?php elseif(request()->routeIs('admin.ticket.settings')): ?> show
<?php endif; ?>" id="tickets">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/ticket/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.ticket.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/all/tickets'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.tickets.all')); ?>">
            <span class="sub-item">All Tickets</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/pending/tickets'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.tickets.pending')); ?>">
            <span class="sub-item">Pending Tickets</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/open/tickets'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.tickets.open')); ?>">
            <span class="sub-item">Open Tickets</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/closed/tickets'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.tickets.closed')); ?>">
            <span class="sub-item">Closed Tickets</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>


<?php if(empty($admin->role) || (!empty($permissions) && in_array('RSS Feeds', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/rss/create'): ?> active
<?php elseif(request()->path() == 'admin/rss/feeds'): ?> active
<?php elseif(request()->path() == 'admin/rss'): ?> active
<?php elseif(request()->is('admin/rss/edit/*')): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#rss">
    <i class="fa fa-rss"></i>
    <p>RSS Feeds</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/rss/create'): ?> show
<?php elseif(request()->path() == 'admin/rss/feeds'): ?> show
<?php elseif(request()->path() == 'admin/rss'): ?> show
<?php elseif(request()->is('admin/rss/edit/*')): ?> show
<?php endif; ?>" id="rss">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/rss/create'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.rss.create')); ?>">
            <span class="sub-item">Import RSS Feeds</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/rss/feeds'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.rss.feed'). '?language=' . $default->code); ?>">
            <span class="sub-item">RSS Feeds</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/rss'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.rss.index'). '?language=' . $default->code); ?>">
            <span class="sub-item">RSS Posts</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>



<?php if(empty($admin->role) || (!empty($permissions) && in_array('Users Management', $permissions))): ?>
<li class="nav-item
<?php if(request()->routeIs('admin.register.user')): ?> active
<?php elseif(request()->routeIs('register.user.view')): ?> active
<?php elseif(request()->routeIs('register.user.changePass')): ?> active

<?php elseif(request()->path() == 'admin/pushnotification/settings'): ?> active
<?php elseif(request()->path() == 'admin/pushnotification/send'): ?> active

<?php elseif(request()->path() == 'admin/subscribers'): ?> active
<?php elseif(request()->path() == 'admin/mailsubscriber'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#usersManagement">
    <i class="la flaticon-users"></i>
    <p>Users Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->routeIs('admin.register.user')): ?> show
<?php elseif(request()->routeIs('register.user.view')): ?> show
<?php elseif(request()->routeIs('register.user.changePass')): ?> show

<?php elseif(request()->path() == 'admin/pushnotification/settings'): ?> show
<?php elseif(request()->path() == 'admin/pushnotification/send'): ?> show

<?php elseif(request()->path() == 'admin/subscribers'): ?> show
<?php elseif(request()->path() == 'admin/mailsubscriber'): ?> show
<?php endif; ?>" id="usersManagement">
<ul class="nav nav-collapse">

    
    <li class="
    <?php if(request()->routeIs('admin.register.user')): ?> active
    <?php elseif(request()->routeIs('register.user.view')): ?> active
    <?php elseif(request()->routeIs('register.user.changePass')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.register.user')); ?>">
        <span class="sub-item">Registered Users</span>
    </a>
</li>


<li class="
<?php if(request()->path() == 'admin/pushnotification/settings'): ?> selected
<?php elseif(request()->path() == 'admin/pushnotification/send'): ?> selected
<?php endif; ?>">
<a data-toggle="collapse" href="#pushNotification">
    <span class="sub-item">Push Notification</span>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/pushnotification/settings'): ?> show
<?php elseif(request()->path() == 'admin/pushnotification/send'): ?> show
<?php endif; ?>" id="pushNotification">
<ul class="nav nav-collapse subnav">
    <li class="<?php if(request()->path() == 'admin/pushnotification/settings'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.pushnotification.settings')); ?>">
            <span class="sub-item">Settings</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/pushnotification/send'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.pushnotification.send')); ?>">
            <span class="sub-item">Send Notification</span>
        </a>
    </li>
</ul>
</div>
</li>


<li class="
<?php if(request()->path() == 'admin/subscribers'): ?> selected
<?php elseif(request()->path() == 'admin/mailsubscriber'): ?> selected
<?php endif; ?>">
<a data-toggle="collapse" href="#subscribers">
    <span class="sub-item">Subscribers</span>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/subscribers'): ?> show
<?php elseif(request()->path() == 'admin/mailsubscriber'): ?> show
<?php endif; ?>" id="subscribers">
<ul class="nav nav-collapse subnav">
    <li class="<?php if(request()->path() == 'admin/subscribers'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.subscriber.index')); ?>">
            <span class="sub-item">Subscribers</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/mailsubscriber'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.mailsubscriber')); ?>">
            <span class="sub-item">Mail to Subscribers</span>
        </a>
    </li>
</ul>
</div>
</li>
</ul>
</div>
</li>
<?php endif; ?>



<?php if(empty($admin->role) || (!empty($permissions) && in_array('Announcement Popup', $permissions))): ?>
<li class="nav-item
<?php if(request()->path() == 'admin/popup/create'): ?> active
<?php elseif(request()->path() == 'admin/popup/types'): ?> active
<?php elseif(request()->is('admin/popup/*/edit')): ?> active
<?php elseif(request()->path() == 'admin/popups'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#announcementPopup">
    <i class="fas fa-bullhorn"></i>
    <p>Announcement Popup</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/popup/create'): ?> show
<?php elseif(request()->path() == 'admin/popup/types'): ?> show
<?php elseif(request()->path() == 'admin/popups'): ?> show
<?php elseif(request()->is('admin/popup/*/edit')): ?> show
<?php endif; ?>" id="announcementPopup">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/popup/types'): ?> active
        <?php elseif(request()->path() == 'admin/popup/create'): ?> active
        <?php endif; ?>">
        <a href="<?php echo e(route('admin.popup.types')); ?>">
            <span class="sub-item">Add Popup</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/popups'): ?> active
        <?php elseif(request()->is('admin/popup/*/edit')): ?> active
        <?php endif; ?>">
        <a href="<?php echo e(route('admin.popup.index') . '?language=' . $default->code); ?>">
            <span class="sub-item">Popups</span>
        </a>
    </li>
</ul>
</div>
</li>
<?php endif; ?>


<?php if(empty($admin->role) || (!empty($permissions) && in_array('Basic Settings', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/logo'): ?> active
<?php elseif(request()->path() == 'admin/file-manager'): ?> active
<?php elseif(request()->path() == 'admin/preloader'): ?> active
<?php elseif(request()->path() == 'admin/basicinfo'): ?> active
<?php elseif(request()->path() == 'admin/support'): ?> active
<?php elseif(request()->path() == 'admin/social'): ?> active
<?php elseif(request()->is('admin/social/*')): ?> active
<?php elseif(request()->path() == 'admin/heading'): ?> active
<?php elseif(request()->path() == 'admin/script'): ?> active
<?php elseif(request()->path() == 'admin/seo'): ?> active
<?php elseif(request()->path() == 'admin/maintainance'): ?> active
<?php elseif(request()->path() == 'admin/cookie-alert'): ?> active
<?php elseif(request()->path() == 'admin/mail-from-admin'): ?> active
<?php elseif(request()->path() == 'admin/mail-to-admin'): ?> active
<?php elseif(request()->routeIs('admin.featuresettings')): ?> active
<?php elseif(request()->path() == 'admin/email-templates'): ?> active
<?php elseif(request()->routeIs('admin.email.editTemplate')): ?> active
<?php elseif(request()->path() == 'admin/languages'): ?> active
<?php elseif(request()->is('admin/language/*/edit')): ?> active
<?php elseif(request()->is('admin/language/*/edit/keyword')): ?> active
<?php elseif(request()->path() == 'admin/gateways'): ?> active
<?php elseif(request()->path() == 'admin/offline/gateways'): ?> active
<?php elseif(request()->path() == 'admin/backup'): ?> active
<?php elseif(request()->path() == 'admin/sitemap'): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#basic">
    <i class="la flaticon-settings"></i>
    <p>Settings</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/logo'): ?> show
<?php elseif(request()->path() == 'admin/file-manager'): ?> show
<?php elseif(request()->path() == 'admin/preloader'): ?> show
<?php elseif(request()->path() == 'admin/basicinfo'): ?> show
<?php elseif(request()->path() == 'admin/support'): ?> show
<?php elseif(request()->path() == 'admin/social'): ?> show
<?php elseif(request()->is('admin/social/*')): ?> show
<?php elseif(request()->path() == 'admin/heading'): ?> show
<?php elseif(request()->path() == 'admin/script'): ?> show
<?php elseif(request()->path() == 'admin/seo'): ?> show
<?php elseif(request()->path() == 'admin/maintainance'): ?> show
<?php elseif(request()->path() == 'admin/cookie-alert'): ?> show
<?php elseif(request()->path() == 'admin/mail-from-admin'): ?> show
<?php elseif(request()->path() == 'admin/mail-to-admin'): ?> show
<?php elseif(request()->routeIs('admin.featuresettings')): ?> show
<?php elseif(request()->path() == 'admin/email-templates'): ?> show
<?php elseif(request()->routeIs('admin.email.editTemplate')): ?> show
<?php elseif(request()->path() == 'admin/languages'): ?> show
<?php elseif(request()->is('admin/language/*/edit')): ?> show
<?php elseif(request()->is('admin/language/*/edit/keyword')): ?> show
<?php elseif(request()->path() == 'admin/gateways'): ?> show
<?php elseif(request()->path() == 'admin/offline/gateways'): ?> show
<?php elseif(request()->path() == 'admin/backup'): ?> show
<?php elseif(request()->path() == 'admin/sitemap'): ?> show
<?php endif; ?>" id="basic">
<ul class="nav nav-collapse">
    <li class="<?php if(request()->path() == 'admin/basicinfo'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.basicinfo')); ?>">
            <span class="sub-item">General Settings</span>
        </a>
    </li>
    <li class="submenu">
        <a data-toggle="collapse" href="#emailset" aria-expanded="<?php echo e((request()->path() == 'admin/mail-from-admin' || request()->path() == 'admin/mail-to-admin' || request()->path() == 'admin/email-templates' || request()->routeIs('admin.email.editTemplate')) ? 'true' : 'false'); ?>">
            <span class="sub-item">Email Settings</span>
            <span class="caret"></span>
        </a>
        <div class="collapse <?php echo e((request()->path() == 'admin/mail-from-admin' || request()->path() == 'admin/mail-to-admin' || request()->path() == 'admin/email-templates' || request()->routeIs('admin.email.editTemplate')) ? 'show' : ''); ?>" id="emailset" style="">
            <ul class="nav nav-collapse subnav">
                <li class="<?php if(request()->path() == 'admin/mail-from-admin'): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.mailFromAdmin')); ?>">
                        <span class="sub-item">Mail from Admin</span>
                    </a>
                </li>
                <li class="<?php if(request()->path() == 'admin/mail-to-admin'): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.mailToAdmin')); ?>">
                        <span class="sub-item">Mail to Admin</span>
                    </a>
                </li>
                <li class="<?php if(request()->path() == 'admin/email-templates'): ?> active
                    <?php elseif(request()->routeIs('admin.email.editTemplate')): ?> active
                    <?php endif; ?>">
                    <a href="<?php echo e(route('admin.email.templates')); ?>">
                        <span class="sub-item">Email Templates</span>
                    </a>
                </li>
            </ul>
        </div>
    </li>
    <li class="<?php if(request()->path() == 'admin/file-manager'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.file-manager')); ?>">
            <span class="sub-item">File Manager</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/logo'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.logo')); ?>">
            <span class="sub-item">Logo & Images</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/preloader'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.preloader')); ?>">
            <span class="sub-item">Preloader</span>
        </a>
    </li>
    <li class="<?php if(request()->routeIs('admin.featuresettings')): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.featuresettings') . '?language=' . $default->code); ?>">
            <span class="sub-item">Preferences</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/support'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.support') . '?language=' . $default->code); ?>">
            <span class="sub-item">Support Informations</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/social'): ?> active
        <?php elseif(request()->is('admin/social/*')): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.social.index')); ?>">
            <span class="sub-item">Social Links</span>
        </a>
    </li>
    <li class="<?php if(request()->path() == 'admin/heading'): ?> active <?php endif; ?>">
        <a href="<?php echo e(route('admin.heading') . '?language=' . $default->code); ?>">
            <span class="sub-item">Page Headings</span>
        </a>
    </li>
    <li class="
    <?php if(request()->path() == 'admin/gateways'): ?> selected
    <?php elseif(request()->path() == 'admin/offline/gateways'): ?> selected
    <?php endif; ?>">
    <a data-toggle="collapse" href="#gateways">
        <span class="sub-item">Payment Gateways</span>
        <span class="caret"></span>
    </a>
    <div class="collapse
    <?php if(request()->path() == 'admin/gateways'): ?> show
    <?php elseif(request()->path() == 'admin/offline/gateways'): ?> show
    <?php endif; ?>" id="gateways">
    <ul class="nav nav-collapse subnav">
        <li class="<?php if(request()->path() == 'admin/gateways'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.gateway.index')); ?>">
                <span class="sub-item">Online Gateways</span>
            </a>
        </li>
        <li class="<?php if(request()->path() == 'admin/offline/gateways'): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.gateway.offline') . '?language=' . $default->code); ?>">
                <span class="sub-item">Offline Gateways</span>
            </a>
        </li>
    </ul>
</div>
</li>
<li class="
<?php if(request()->path() == 'admin/languages'): ?> active
<?php elseif(request()->is('admin/language/*/edit')): ?> active
<?php elseif(request()->is('admin/language/*/edit/keyword')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.language.index')); ?>">
    <span class="sub-item">Language</span>
</a>
</li>
<li class="<?php if(request()->path() == 'admin/script'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.script')); ?>">
        <span class="sub-item">Plugins</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/seo'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.seo') . '?language=' . $default->code); ?>">
        <span class="sub-item">SEO Information</span>
    </a>
</li>
<li class="<?php if(request()->path() == 'admin/maintainance'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.maintainance')); ?>">
        <span class="sub-item">Maintenance Mode</span>
    </a>
</li>

<li class="<?php if(request()->path() == 'admin/cookie-alert'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.cookie.alert') . '?language=' . $default->code); ?>">
        <span class="sub-item">Cookie Alert</span>
    </a>
</li>

<li class="
<?php if(request()->path() == 'admin/backup'): ?> selected
<?php elseif(request()->path() == 'admin/sitemap'): ?> selected
<?php endif; ?>">
<a data-toggle="collapse" href="#misc">
    <span class="sub-item">MISC</span>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/backup'): ?> show
<?php elseif(request()->path() == 'admin/sitemap'): ?> show
<?php endif; ?>" id="misc">
<ul class="nav nav-collapse subnav">
    <li class="
    <?php if(request()->path() == 'admin/sitemap'): ?> selected
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.sitemap.index') . '?language=' . $default->code); ?>">
        <span class="sub-item">Sitemap</span>
    </a>
</li>
<li class="
<?php if(request()->path() == 'admin/backup'): ?> selected
<?php endif; ?>">
<a href="<?php echo e(route('admin.backup.index')); ?>">
    <span class="sub-item">Database Backup</span>
</a>
</li>
<li>
    <a href="<?php echo e(route('admin.cache.clear')); ?>">
        <span class="sub-item">Clear Cache</span>
    </a>
</li>
</ul>
</div>
</li>
</ul>
</div>
</li>
<?php endif; ?>


<?php if(empty($admin->role) || (!empty($permissions) && in_array('Admins Management', $permissions))): ?>

<li class="nav-item
<?php if(request()->path() == 'admin/roles'): ?> active
<?php elseif(request()->is('admin/role/*/permissions/manage')): ?> active
<?php elseif(request()->path() == 'admin/users'): ?> active
<?php elseif(request()->is('admin/user/*/edit')): ?> active
<?php endif; ?>">
<a data-toggle="collapse" href="#adminsManagement">
    <i class="fas fa-users-cog"></i>
    <p>Admins Management</p>
    <span class="caret"></span>
</a>
<div class="collapse
<?php if(request()->path() == 'admin/roles'): ?> show
<?php elseif(request()->is('admin/role/*/permissions/manage')): ?> show
<?php elseif(request()->path() == 'admin/users'): ?> show
<?php elseif(request()->is('admin/user/*/edit')): ?> show
<?php endif; ?>" id="adminsManagement">
<ul class="nav nav-collapse">
    <li class="
    <?php if(request()->path() == 'admin/roles'): ?> active
    <?php elseif(request()->is('admin/role/*/permissions/manage')): ?> active
    <?php endif; ?>">
    <a href="<?php echo e(route('admin.role.index')); ?>">
        <span class="sub-item">Role Management</span>
    </a>
</li>
<li class="
<?php if(request()->path() == 'admin/users'): ?> active
<?php elseif(request()->is('admin/user/*/edit')): ?> active
<?php endif; ?>">
<a href="<?php echo e(route('admin.user.index')); ?>">
    <span class="sub-item">Admins</span>
</a>
</li>
</ul>
</div>
</li>
<?php endif; ?>



<?php if(empty($admin->role) || (!empty($permissions) && in_array('Client Feedbacks', $permissions))): ?>

<li class="nav-item <?php if(request()->path() == 'admin/feedbacks'): ?> active <?php endif; ?>">
    <a href="<?php echo e(route('admin.client_feedbacks')); ?>">
        <i class="fas fa-pen-fancy"></i>
        <p>Client Feedbacks</p>
    </a>
</li>
<?php endif; ?>
</ul>
</div>
</div>
</div>
<?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/admin/partials/side-navbar.blade.php ENDPATH**/ ?>