<?php $__env->startSection('content'); ?>
  <div class="page-header">
    <h4 class="page-title">Admins</h4>
    <ul class="breadcrumbs">
      <li class="nav-home">
        <a href="<?php echo e(route('admin.dashboard')); ?>">
          <i class="flaticon-home"></i>
        </a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">Admins Management</a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">Admins</a>
      </li>
    </ul>
  </div>
  <div class="row">
    <div class="col-md-12">

      <div class="card">
        <div class="card-header">
          <div class="card-title d-inline-block">Admins</div>
          <a href="#" class="btn btn-primary float-right" data-toggle="modal" data-target="#createModal"><i class="fas fa-plus"></i> Add Admin</a>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-lg-12">
              <?php if(count($users) == 0): ?>
                <h3 class="text-center">NO USER FOUND</h3>
              <?php else: ?>
                <div class="table-responsive">
                  <table class="table table-striped mt-3" id="basic-datatables">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Picture</th>
                        <th scope="col">Username</th>
                        <th scope="col">Email</th>
                        <th scope="col">Role</th>
                        <th scope="col">Status</th>
                        <th scope="col" width="15%">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($user->id != Auth::guard('admin')->user()->id): ?>
                          <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                              <img src="<?php echo e(asset('assets/admin/img/propics/'.$user->image)); ?>" alt="" width="45">
                            </td>
                            <td><?php echo e($user->username); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td>
                              <?php if(empty($user->role)): ?>
                                <span class="badge badge-danger">Owner</span>
                              <?php else: ?>
                                <?php echo e($user->role->name); ?>

                              <?php endif; ?>
                            </td>
                            <td>
                              <?php if($user->status == 1): ?>
                                <span class="badge badge-success">Active</span>
                              <?php elseif($user->status == 0): ?>
                                <span class="badge badge-danger">Deactive</span>
                              <?php endif; ?>
                            </td>
                            <td width="15%">
                              <a class="btn btn-secondary btn-sm" href="<?php echo e(route('admin.user.edit', $user->id)); ?>">
                                  <i class="fas fa-edit"></i>
                              </a>
                              <form class="deleteform d-inline-block" action="<?php echo e(route('admin.user.delete')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>">
                                <button type="submit" class="btn btn-danger btn-sm deletebtn">
                                    <i class="fas fa-trash"></i>
                                </button>
                              </form>
                            </td>
                          </tr>
                        <?php endif; ?>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- Create Users Modal -->
  <?php if ($__env->exists('admin.user.create')) echo $__env->make('admin.user.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Image LFM Modal -->
    <div class="modal fade lfm-modal" id="lfmModal1" tabindex="-1" role="dialog" aria-labelledby="lfmModalTitle" aria-hidden="true">
        <i class="fas fa-times-circle"></i>
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <iframe src="<?php echo e(url('laravel-filemanager')); ?>?serial=1" style="width: 100%; height: 500px; overflow: hidden; border: none;"></iframe>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/admin/user/index.blade.php ENDPATH**/ ?>