<?php $__env->startSection('content'); ?>
  <div class="page-header">
    <h4 class="page-title">Client Feedbacks</h4>
    <ul class="breadcrumbs">
      <li class="nav-home">
        <a href="<?php echo e(route('admin.dashboard')); ?>">
          <i class="flaticon-home"></i>
        </a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">Client Feedbacks</a>
      </li>
    </ul>
  </div>

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card-title d-inline-block">Feedbacks</div>
                </div>
                <div class="col-lg-6 mt-2 mt-lg-0">
                  <button class="btn btn-danger float-right btn-sm mr-2 d-none bulk-delete"
                    data-href="<?php echo e(route('admin.feedback.bulk.delete')); ?>"><i class="flaticon-interface-5"></i> Delete</button>
                </div>
            </div>
        </div>

        <div class="card-body">
          <div class="row">
            <div class="col-lg-12">
              <?php if(count($feedbacks) == 0): ?>
                <h3 class="text-center">NO FEEDBACK FOUND</h3>
              <?php else: ?>
                <div class="table-responsive">
                  <table class="table table-striped mt-3">
                    <thead>
                      <tr>
                        <th scope="col">
                          <input type="checkbox" class="bulk-check" data-val="all">
                        </th>
                        <th scope="col">Name</th>
                        <th scope="col">Email</th>
                        <th scope="col">Subject</th>
                        <th scope="col">Rating</th>
                        <th scope="col">Feedback</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $feedbacks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feedback): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td>
                          <input type="checkbox" class="bulk-check" data-val="<?php echo e($feedback->id); ?>">
                        </td>
                        <td><?php echo e($feedback->name); ?></td>
                        <td><?php echo e($feedback->email); ?></td>
                        <?php
                          $sub = str_replace('-', ' ', $feedback->subject);
                        ?>
                        <td class="text-capitalize"><?php echo e($sub); ?></td>
                        <td><?php echo e($feedback->rating); ?></td>
                        <td>
                          <a class="btn btn-sm btn-info" href="#" data-toggle="modal" data-target="#feedbackModal<?php echo e($feedback->id); ?>">Show</a>
                        </td>
                        <td>
                          <form class="deleteform d-inline-block" action="<?php echo e(route('admin.delete_feedback')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="feedback_id" value="<?php echo e($feedback->id); ?>">
                            <button type="submit" class="btn btn-danger btn-sm deletebtn">
                              <span class="btn-label">
                                <i class="fas fa-trash"></i>
                              </span>
                              Delete
                            </button>
                          </form>
                        </td>
                      </tr>

                      <?php if ($__env->exists('admin.feedback.show_feedback')) echo $__env->make('admin.feedback.show_feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <div class="card-footer">
          <div class="row">
            <div class="d-inline-block mx-auto">
              <?php echo e($feedbacks->links()); ?>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/admin/feedback/client_feedback.blade.php ENDPATH**/ ?>