<!DOCTYPE html>
<html lang="en">
   <head>
      <!--Start of Google Analytics script-->
      <?php if($bs->is_analytics == 1): ?>
      <?php echo $bs->google_analytics_script; ?>

      <?php endif; ?>
      <!--End of Google Analytics script-->

      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
      <meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>">

      <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
      <title><?php echo e($bs->website_title); ?> <?php echo $__env->yieldContent('pagename'); ?></title>
      <!-- favicon -->
      <link rel="shortcut icon" href="<?php echo e(asset('assets/front/img/'.$bs->favicon)); ?>" type="image/x-icon">
      <!-- bootstrap css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
      <!-- plugin css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.min.css')); ?>">
      <!--default css-->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/default.css')); ?>">
      <!-- main css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lawyer-style.css')); ?>">
      <!-- common css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/common-style.css')); ?>">
      <!-- responsive css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">
      <!-- lawyer responsive css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lawyer-responsive.css')); ?>">

      <?php if($bs->is_tawkto == 1 || $bex->is_whatsapp == 1): ?>
      <style>
        #scroll_up {
            right: auto;
            left: 20px;
        }
      </style>
      <?php endif; ?>
      <?php if(count($langs) == 0): ?>
      <style media="screen">
      .support-bar-area ul.social-links li:last-child {
          margin-right: 0px;
      }
      .support-bar-area ul.social-links::after {
          display: none;
      }
      </style>
      <?php endif; ?>

      <!-- common base color change -->
      <link href="<?php echo e(url('/')); ?>/assets/front/css/common-base-color.php?color=<?php echo e($bs->base_color); ?>" rel="stylesheet">
      <!-- base color change -->
      <link href="<?php echo e(url('/')); ?>/assets/front/css/lawyer-base-color.php?color=<?php echo e($bs->base_color); ?>" rel="stylesheet">


      <?php if($rtl == 1): ?>
      <!-- RTL css -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/rtl.css')); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lawyer-rtl.css')); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/pb-rtl.css')); ?>">
      <?php endif; ?>
      <?php echo $__env->yieldContent('styles'); ?>

      <!-- jquery js -->
      <script src="<?php echo e(asset('assets/front/js/jquery-3.3.1.min.js')); ?>"></script>

      <?php if($bs->is_appzi == 1): ?>
      <!-- Start of Appzi Feedback Script -->
      <script async src="https://app.appzi.io/bootstrap/bundle.js?token=<?php echo e($bs->appzi_token); ?>"></script>
      <!-- End of Appzi Feedback Script -->
      <?php endif; ?>

      <!-- Start of Facebook Pixel Code -->
      <?php if($be->is_facebook_pexel == 1): ?>
        <?php echo $be->facebook_pexel_script; ?>

      <?php endif; ?>
      <!-- End of Facebook Pixel Code -->

      <!--Start of Appzi script-->
      <?php if($bs->is_appzi == 1): ?>
      <?php echo $bs->appzi_script; ?>

      <?php endif; ?>
      <!--End of Appzi script-->
   </head>



   <body <?php if($rtl == 1): ?> dir="rtl" <?php endif; ?>>

    <div class="top_header">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="top_left">
                        <span><i class="fas fa-headphones"></i><a href="tel:<?php echo e($bs->support_phone); ?>"><?php echo e($bs->support_phone); ?></a></span>
                        <span><i class="far fa-envelope"></i><a href="mailto:<?php echo e($bs->support_email); ?>"><?php echo e($bs->support_email); ?></a></span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="top_right d-flex align-items-center justify-content-end">
                        <ul class="social">
                            <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e($social->url); ?>"><i class="<?php echo e($social->icon); ?>"></i></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <?php if(!empty($currentLang) && count($langs) > 1): ?>
                            <div class="dropdown">
                                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><i class="fas fa-globe"></i><?php echo e(convertUtf8($currentLang->name)); ?>

                                </button>
                                <div class="dropdown-menu">
                                    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="dropdown-item" href='<?php echo e(route('changeLanguage', $lang->code)); ?>'><?php echo e(convertUtf8($lang->name)); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(auth()->guard()->guest()): ?>
                        <?php if($bex->is_user_panel == 1): ?>
                            <ul class="login">
                                <li><a href="<?php echo e(route('user.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                            </ul>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php if(auth()->guard()->check()): ?>
                        <div class="dropdown ml-4">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><i class="far fa-user mr-1"></i> <?php echo e(Auth::user()->username); ?>

                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('user-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                                <?php if($bex->recurring_billing == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user-packages')); ?>"><?php echo e(__('Packages')); ?></a>
                                <?php endif; ?>
                                <?php if($bex->is_shop == 1 && $bex->catalog_mode == 0): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user-orders')); ?>"><?php echo e(__('Product Orders')); ?> </a>
                                <?php endif; ?>
                                <?php if($bex->recurring_billing == 0): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user-package-orders')); ?>"><?php echo e(__('Package Orders')); ?> </a>
                                <?php endif; ?>

                                <?php if($bex->is_course == 1): ?>
                                <a class="dropdown-item" href="<?php echo e(route('user.course_orders')); ?>" ><?php echo e(__('Courses')); ?></a>
                                <?php endif; ?>

                                <?php if($bex->is_event == 1): ?>
                                <a class="dropdown-item" href="<?php echo e(route('user-events')); ?>" ><?php echo e(__('Event Bookings')); ?></a>
                                <?php endif; ?>

                                <?php if($bex->is_donation == 1): ?>
                                <a class="dropdown-item" href="<?php echo e(route('user-donations')); ?>" ><?php echo e(__('Donations')); ?></a>
                                <?php endif; ?>
                                <?php if($bex->is_ticket == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user-tickets')); ?>"><?php echo e(__('Support Tickets')); ?></a>
                                <?php endif; ?>
                                <a class="dropdown-item" href="<?php echo e(route('user-profile')); ?>"><?php echo e(__('Edit Profile')); ?></a>
                                <?php if($bex->is_shop == 1 && $bex->catalog_mode == 0): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('shpping-details')); ?>"><?php echo e(__('Shipping Details')); ?></a>
                                    <a class="dropdown-item" href="<?php echo e(route('billing-details')); ?>"><?php echo e(__('Billing Details')); ?></a>
                                    <a class="dropdown-item" href="<?php echo e(route('user-reset')); ?>"><?php echo e(__('Change Password')); ?></a>
                                <?php endif; ?>
                                <a class="dropdown-item" href="<?php echo e(route('user-logout')); ?>" target="_self"><?php echo e(__('Logout')); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Start finlance_header area -->
    <?php if ($__env->exists('front.lawyer.partials.navbar')) echo $__env->make('front.lawyer.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End finlance_header area -->


    <?php if(!request()->routeIs('front.index') && !request()->routeIs('front.packageorder.confirmation')): ?>
        <!--   breadcrumb area start   -->
        <div class="breadcrumb-area lazy" data-bg="<?php echo e(asset('assets/front/img/' . $bs->breadcrumb)); ?>" style="background-size:cover;">
            <div class="container">
            <div class="breadcrumb-txt">
                <div class="row">
                    <div class="col-xl-7 col-lg-8 col-sm-10">
                        <span><?php echo $__env->yieldContent('breadcrumb-title'); ?></span>
                        <h1><?php echo $__env->yieldContent('breadcrumb-subtitle'); ?></h1>
                        <ul class="breadcumb">
                        <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(__('Home')); ?></a></li>
                        <li><?php echo $__env->yieldContent('breadcrumb-link'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            </div>
            <div class="breadcrumb-area-overlay" style="background-color: #<?php echo e($be->breadcrumb_overlay_color); ?>;opacity: <?php echo e($be->breadcrumb_overlay_opacity); ?>;"></div>
        </div>
        <!--   breadcrumb area end    -->
    <?php endif; ?>

    <?php echo $__env->yieldContent('content'); ?>


    <!--    announcement banner section start   -->
    <a class="announcement-banner" href="<?php echo e(asset('assets/front/img/'.$bs->announcement)); ?>"></a>
    <!--    announcement banner section end   -->


    <!-- Start lawyer_footer section -->
    <footer class="lawyer_footer footer_v1 dark_bg">
        <?php if(!($bex->home_page_pagebuilder == 0 && $bs->top_footer_section == 0)): ?>
        <div class="footer_top pt-120 pb-120">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="widget_box about_widget">
                            <img data-src="<?php echo e(asset('assets/front/img/'.$bs->footer_logo)); ?>" class="img-fluid lazy" alt="">
                            <p>
                                <?php if(strlen(convertUtf8($bs->footer_text)) > 150): ?>
                                   <?php echo e(substr(convertUtf8($bs->footer_text), 0, 150)); ?><span style="display: none;"><?php echo e(substr(convertUtf8($bs->footer_text), 150)); ?></span>
                                   <a href="#" class="see-more"><?php echo e(__('see more')); ?>...</a>
                                <?php else: ?>
                                   <?php echo e(convertUtf8($bs->footer_text)); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="widget_box contact_widget">
                            <h4 class="widget_title"><?php echo e(__('Contact Us')); ?></h4>
                            <p>
                                <span><i class="fas fa-map-marker-alt"></i></span>
                                <?php
                                $addresses = explode(PHP_EOL, $bex->contact_addresses);
                                ?>

                                <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($address); ?>

                                    <?php if(!$loop->last): ?>
                                        |
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                            <p><span><?php echo e(__('Phone')); ?>:</span>
                                <?php
                                $phones = explode(',', $bex->contact_numbers);
                                ?>

                                <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($phone); ?>

                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </p>
                            <p><span><?php echo e(__('Email')); ?>:</span>
                                <?php
                                    $mails = explode(',', $bex->contact_mails);
                                ?>
                                <?php $__currentLoopData = $mails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($mail); ?>

                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="widget_box">
                            <h4 class="widget_title"><?php echo e(__('Useful Links')); ?></h4>
                            <ul class="widget_link">
                                <?php $__currentLoopData = $ulinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ulink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e($ulink->url); ?>"><?php echo e(convertUtf8($ulink->name)); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="widget_box newsletter_box">
                            <h4 class="widget_title"><?php echo e(__('Newsletter')); ?></h4>
                            <p><?php echo e(convertUtf8($bs->newsletter_text)); ?></p>
                            <form id="footerSubscribeForm" action="<?php echo e(route('front.subscribe')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="form_group">
                                    <input type="email" class="form_control" placeholder="<?php echo e(__('Enter Email Address')); ?>" name="email" required>
                                    <p id="erremail" class="text-danger mb-0 err-email"></p>
                                    <button class="lawyer_btn" type="submit"><?php echo e(__('Subscribe')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if(!($bex->home_page_pagebuilder == 0 && $bs->copyright_section == 0)): ?>
        <div class="footer_bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="copyright_text">
                            <p><?php echo replaceBaseUrl(convertUtf8($bs->copyright_text)); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="social_box">
                            <ul>
                                <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a target="_blank" href="<?php echo e($social->url); ?>"><i class="<?php echo e($social->icon); ?>"></i></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </footer><!-- End lawyer_footer section -->

    <?php if($bex->is_shop == 1 && $bex->catalog_mode == 0): ?>
        <div id="cartIconWrapper">
            <a class="d-block" id="cartIcon" href="<?php echo e(route('front.cart')); ?>">
                <div class="cart-length">
                    <i class="fas fa-cart-plus"></i>
                    <span class="length"><?php echo e(cartLength()); ?> <?php echo e(__('ITEMS')); ?></span>
                </div>
                <div class="cart-total">
                    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?>

                    <?php echo e(cartTotal()); ?>

                    <?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                </div>
            </a>
        </div>
    <?php endif; ?>

    <!--====== PRELOADER PART START ======-->
    <?php if($bex->preloader_status == 1): ?>
    <div id="preloader">
        <div class="loader revolve">
            <img src="<?php echo e(asset('assets/front/img/' . $bex->preloader)); ?>" alt="">
        </div>
    </div>
    <?php endif; ?>
    <!--====== PRELOADER PART ENDS ======-->

    <!--Scroll-up-->
    <a id="scroll_up" ><i class="fas fa-angle-up"></i></a>

    
    <div id="WAButton"></div>

    
    <?php if($be->cookie_alert_status == 1): ?>
    <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    

    
    <?php if ($__env->exists('front.partials.popups')) echo $__env->make('front.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

      <?php
        $mainbs = [];
        $mainbs = json_encode($mainbs);
      ?>
      <script>
        var mainbs = <?php echo $mainbs; ?>;
        var mainurl = "<?php echo e(url('/')); ?>";
        var vap_pub_key = "<?php echo e(env('VAPID_PUBLIC_KEY')); ?>";

        var rtl = <?php echo e($rtl); ?>;
      </script>
      <!-- popper js -->
      <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
      <!-- bootstrap js -->
      <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
      <!-- Plugin js -->
      <script src="<?php echo e(asset('assets/front/js/plugin.min.js')); ?>"></script>
      <!-- main js -->
      <script src="<?php echo e(asset('assets/front/js/lawyer-main.js')); ?>"></script>
      <!-- pagebuilder custom js -->
      <script src="<?php echo e(asset('assets/front/js/common-main.js')); ?>"></script>
      
      <?php if($bex->is_whatsapp == 1): ?>
        <script type="text/javascript">
            var whatsapp_popup = <?php echo e($bex->whatsapp_popup); ?>;
            var whatsappImg = "<?php echo e(asset('assets/front/img/whatsapp.svg')); ?>";
            $(function () {
                $('#WAButton').floatingWhatsApp({
                    phone: "<?php echo e($bex->whatsapp_number); ?>", //WhatsApp Business phone number
                    headerTitle: "<?php echo e($bex->whatsapp_header_title); ?>", //Popup Title
                    popupMessage: `<?php echo nl2br($bex->whatsapp_popup_message); ?>`, //Popup Message
                    showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
                    buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
                    position: "right" //Position: left | right

                });
            });
        </script>
      <?php endif; ?>

      <?php echo $__env->yieldContent('scripts'); ?>

      <?php if(session()->has('success')): ?>
      <script>
         toastr["success"]("<?php echo e(__(session('success'))); ?>");
      </script>
      <?php endif; ?>

      <?php if(session()->has('error')): ?>
      <script>
         toastr["error"]("<?php echo e(__(session('error'))); ?>");
      </script>
      <?php endif; ?>

      <!--Start of subscribe functionality-->
      <script>
        $(document).ready(function() {
          $("#subscribeForm, #footerSubscribeForm").on('submit', function(e) {
            // console.log($(this).attr('id'));

            e.preventDefault();

            let formId = $(this).attr('id');
            let fd = new FormData(document.getElementById(formId));
            let $this = $(this);

            $.ajax({
              url: $(this).attr('action'),
              type: $(this).attr('method'),
              data: fd,
              contentType: false,
              processData: false,
              success: function(data) {
                // console.log(data);
                if ((data.errors)) {
                  $this.find(".err-email").html(data.errors.email[0]);
                } else {
                  toastr["success"]("You are subscribed successfully!");
                  $this.trigger('reset');
                  $this.find(".err-email").html('');
                }
              }
            });
          });

            // lory slider responsive
            $(".gjs-lory-frame").each(function() {
                let id = $(this).parent().attr('id');
                $("#"+id).attr('style', 'width: 100% !important');
            });
        });
      </script>
      <!--End of subscribe functionality-->

      <!--Start of Tawk.to script-->
      <?php if($bs->is_tawkto == 1): ?>
      <?php echo $bs->tawk_to_script; ?>

      <?php endif; ?>
      <!--End of Tawk.to script-->

      <!--Start of AddThis script-->
      <?php if($bs->is_addthis == 1): ?>
      <?php echo $bs->addthis_script; ?>

      <?php endif; ?>
      <!--End of AddThis script-->
   </body>
</html>
<?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/lawyer/layout.blade.php ENDPATH**/ ?>