<?php $__env->startSection('pagename'); ?>
 -
 <?php if(empty($category)): ?>
 <?php echo e(__('All')); ?>

 <?php else: ?>
 <?php echo e(convertUtf8($category->name)); ?>

 <?php endif; ?>
 <?php echo e(__('Products')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->products_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->products_meta_description"); ?>


<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/jquery-ui.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($be->product_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($be->product_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Our Product')); ?>

<?php $__env->startSection('content'); ?>

<!--    product section start    -->
<div class="product-area">
    <div class="container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-3 col-md-6">
                <div class="shop-search mt-30">
                    <input type="text" placeholder="Search Keywords" class="input-search" name="search" value="<?php echo e(request()->input('search') ? request()->input('search') : ''); ?>">
                    <i  class="fas fa-search input-search-btn cursor-pointer"></i>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="shop-dropdown mt-30 text-right">
                    <select name="type" id="type_sort">
                        <option value="new" <?php echo e(request()->input('type') == 'new' ? 'selected' : ''); ?>><?php echo e(__('Newest Product')); ?></option>
                        <option value="old" <?php echo e(request()->input('type') == 'old' ? 'selected' : ''); ?>><?php echo e(__('Oldest Product')); ?></option>

                        <?php if($bex->catalog_mode == 0): ?>
                            <option value="hight-to-low" <?php echo e(request()->input('type') == 'high-to-low' ? 'selected' : ''); ?>><?php echo e(__('High To Low')); ?></option>
                            <option value="low-to-high" <?php echo e(request()->input('type') == 'low-to-high' ? 'selected' : ''); ?>><?php echo e(__('Low To High')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-3 col-md-5 col-sm-7 order-2 order-lg-1">
                <div class="shop-sidebar">
                    <div class="shop-box shop-category">
                        <div class="sidebar-title">
                            <h4 class="title"><?php echo e(__('Category')); ?></h4>
                        </div>
                        <div class="category-item">
                            <ul>
                            <li class="<?php echo e(request()->input('category_id') == '' ? 'active-search' : ''); ?>" ><a data-href="0" class="category-id cursor-pointer"><?php echo e(__('All')); ?></a></li>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="<?php echo e(request()->input('category_id') == $category->id ? 'active-search' : ''); ?>"><a data-href="<?php echo e($category->id); ?>" class="category-id cursor-pointer"><?php echo e($category->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php if($be->popular_tags): ?>
                    <div class="shop-box shop-tag mt-30">
                        <div class="sidebar-title">
                            <h4 class="title"><?php echo e(__('Populer Tags')); ?></h4>
                        </div>
                        <div class="tag-item">
                            <ul>
                                <li class="<?php echo e(request()->input('tag') == '' ? 'active-search' : ''); ?>"><a data-href="" class="tag-id cursor-pointer"><?php echo e(__('All')); ?></a></li>
                                <?php $__currentLoopData = explode(',',$be->popular_tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="<?php echo e(request()->input('tag') == $tag ? 'active-search' : ''); ?>"><a data-href="<?php echo e($tag); ?>" class="tag-id cursor-pointer"><?php echo e(convertUtf8($tag)); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
                    <div class="shop-box shop-filter mt-30">
                        <div class="sidebar-title">
                            <h4 class="title"><?php echo e(__('Filter Products')); ?></h4>
                        </div>
                        <div class="filter-item">
                             <ul class="checkbox_common checkbox_style2">
                                <li>
                                    <input type="radio" class="review_val" name="review_value"
                                    <?php echo e(request()->input('review') == '' ? 'checked' : ''); ?>

                                    id="checkbox4" value="">
                                    <label for="checkbox4"><span></span> <?php echo e(__('Show All')); ?></label>
                                </li>

                                <li>
                                    <input type="radio" class="review_val" name="review_value" id="checkbox5" value="4" <?php echo e(request()->input('review') == 4 ? 'checked' : ''); ?>

                                    id="checkbox4" value="all">
                                    <label for="checkbox5"><span></span>4 <?php echo e(__('Star and higher')); ?></label>
                                </li>

                                <li>
                                    <input type="radio" class="review_val" name="review_value" id="checkbox6" value="3" <?php echo e(request()->input('review') == 3 ? 'checked' : ''); ?>

                                    id="checkbox4" value="all">
                                    <label for="checkbox6"><span></span>3 <?php echo e(__('Star and higher')); ?></label>
                                </li>

                                <li>
                                    <input type="radio" class="review_val" name="review_value" id="checkbox7" value="2" <?php echo e(request()->input('review') == 2 ? 'checked' : ''); ?>

                                    id="checkbox4" value="all">
                                    <label for="checkbox7"><span></span>2 <?php echo e(__('Star and higher')); ?></label>
                                </li>

                                <li>
                                    <input type="radio" class="review_val" name="review_value" id="checkbox8" value="1" <?php echo e(request()->input('review') == 1 ? 'checked' : ''); ?>

                                    id="checkbox4" value="all">
                                    <label for="checkbox8"><span></span>1 <?php echo e(__('Star and higher')); ?></label>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if($bex->catalog_mode == 0): ?>
                        <div class="shop-box shop-price mt-30">
                            <div class="sidebar-title">
                                <h4 class="title"><?php echo e(__('Filter By Price')); ?></h4>
                            </div>
                            <div class="price-item">
                                <div class="price-range-box">
                                <form action="#">
                                    <div id="slider-range"></div>
                                    <span><?php echo e(__('Price')); ?>: </span>
                                    <input type="text" name="text" id="amount" />
                                    <button class="btn filter-button" type="button"><?php echo e(__('Filter')); ?></button>
                                </form>
                            </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-9 order-1 order-lg-2">
                <div class="row">
                    <?php if($products->count() > 0): ?>

                  <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="shop-item">
                        <div class="shop-thumb">
                            <img class="lazy" data-src="<?php echo e(asset('assets/front/img/product/featured/'.$product->feature_image)); ?>" alt="">
                            <ul>
                                <?php if($bex->catalog_mode == 0): ?>
                                    <li><a href="<?php echo e(route('front.product.checkout',$product->slug)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Order Now')); ?>"><i class="far fa-credit-card"></i></a></li>

                                    <li><a class="cart-link" data-href="<?php echo e(route('add.cart',$product->id)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Add to Cart')); ?>"><i class="fas fa-shopping-cart"></i></a></li>
                                <?php endif; ?>

                                <li><a href="<?php echo e(route('front.product.details',$product->slug)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('View Details')); ?>"><i class="fas fa-eye"></i></a></li>
                            </ul>
                        </div>
                        <div class="shop-content text-center">
                            <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
                            <div class="rate">
                                <div class="rating" style="width:<?php echo e($product->rating * 20); ?>%"></div>
                            </div>
                            <?php endif; ?>
                            <a class="<?php echo e($bex->product_rating_system == 0 || $bex->catalog_mode == 1 ? 'mt-3' : ''); ?>" href="<?php echo e(route('front.product.details',$product->slug)); ?>">
                                <?php echo e(strlen($product->title) > 40 ? mb_substr($product->title,0,40,'utf-8') . '...' : $product->title); ?>

                            </a> <br>

                            <?php if($bex->catalog_mode == 0): ?>
                                <span>
                                    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->current_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                                    <?php if(!empty($product->previous_price)): ?>
                                        <del>  <span class="prepice"> <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($product->previous_price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></span></del>
                                    <?php endif; ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <?php else: ?>
                    <div class="col-12 text-center py-5 bg-light" style="margin-top: 30px;">
                        <h4 class="text-center"><?php echo e(__('Product Not Found')); ?></h4>
                    </div>
                  <?php endif; ?>
              </div>
                <div class="row">
                    <div class="col-md-12">
                        <nav class="pagination-nav <?php echo e($products->count() > 6 ? 'mb-4' : ''); ?>">
                            <?php echo e($products->appends(['minprice' => request()->input('minprice'), 'maxprice' => request()->input('maxprice'), 'category_id' => request()->input('category_id'), 'type' => request()->input('type'), 'tag' => request()->input('tag'), 'review' => request()->input('review')])->links()); ?>

                        </nav>
                    </div>
                </div>
           </div>
        </div>
    </div>
</div>
<!--    product section ends    -->
<?php
    $maxprice = App\Product::max('current_price');
    $minprice = 0;
?>

<form id="searchForm" class="d-none"  action="<?php echo e(route('front.product')); ?>" method="get">
    <input type="hidden" id="search" name="search" value="<?php echo e(!empty(request()->input('search')) ? request()->input('search') : ''); ?>">

    <?php if($bex->catalog_mode == 0): ?>
        <input type="hidden" id="minprice" name="minprice" value="<?php echo e(!empty(request()->input('minprice')) ? request()->input('minprice') : $minprice); ?>">
        <input type="hidden" id="maxprice" name="maxprice" value="<?php echo e(!empty(request()->input('maxprice')) ? request()->input('maxprice') : $maxprice); ?>">
    <?php endif; ?>

    <input type="hidden" name="category_id" id="category_id" value="<?php echo e(!empty(request()->input('category_id')) ? request()->input('category_id') : null); ?>">
    <input type="hidden" name="type" id="type" value="<?php echo e(!empty(request()->input('type')) ? request()->input('type') : 'new'); ?>">
    <input type="hidden" name="tag" id="tag" value="<?php echo e(!empty(request()->input('tag')) ? request()->input('tag') : ''); ?>">

    <?php if($bex->product_rating_system == 1 && $bex->catalog_mode == 0): ?>
        <input type="hidden" name="review" id="review" value="<?php echo e(!empty(request()->input('review')) ? request()->input('review') : ''); ?>">
    <?php endif; ?>

    <button id="search-button" type="submit"></button>
</form>




<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/front/js/jquery.ui.js')); ?>"></script>

<?php if($bex->catalog_mode == 0): ?>
    <script src="<?php echo e(asset('assets/front/js/cart.js')); ?>"></script>
    <script>
        var position = "<?php echo e($bex->base_currency_symbol_position); ?>";
        var symbol = "<?php echo e($bex->base_currency_symbol); ?>";

        // console.log(position,symbol);
        $( "#slider-range" ).slider({
            range: true,
            min: 0,
            max: '<?php echo e($maxprice); ?>',
            values: [ '<?php echo e(!empty(request()->input('minprice')) ? request()->input('minprice') : $minprice); ?>', <?php echo e(!empty(request()->input('maxprice')) ? request()->input('maxprice') : $maxprice); ?> ],
            slide: function( event, ui ) {
            $( "#amount" ).val( (position == 'left' ? symbol : '') + ui.values[ 0 ] + (position == 'right' ? symbol : '') + " - " + (position == 'left' ? symbol : '') + ui.values[ 1 ] + (position == 'right' ? symbol : '') );
        }
        });
        $( "#amount" ).val( (position == 'left' ? symbol : '') + $( "#slider-range" ).slider( "values", 0 ) + (position == 'right' ? symbol : '') + " - " + (position == 'left' ? symbol : '') + $( "#slider-range" ).slider( "values", 1 ) + (position == 'right' ? symbol : '') );

    </script>
<?php endif; ?>


<script>

    let maxprice = 0;
    let minprice = 0;
    let typeSort = '';
    let category = '';
    let tag = '';
    let review = '';
    let search = '';


    $(document).on('click','.filter-button',function(){
        let filterval = $('#amount').val();
        filterval = filterval.split('-');
        maxprice = filterval[1].replace('$','');
        minprice = filterval[0].replace('$','');
        maxprice = parseInt(maxprice);
        minprice = parseInt(minprice);
        $('#maxprice').val(maxprice);
        $('#minprice').val(minprice);
        $('#search-button').click();
    });

$(document).on('change','#type_sort',function(){
    typeSort = $(this).val();
    $('#type').val(typeSort);
    $('#search-button').click();
})
$(document).ready(function(){
    typeSort = $('#type_sort').val();
    $('#type').val(typeSort);
})

$(document).on('click','.category-id',function(e){
    e.preventDefault();
    category = '';
    if($(this).attr('data-href') != 0){
        category = $(this).attr('data-href');
    }
    $('#category_id').val(category);
    $('#search-button').click();
})
$(document).on('click','.tag-id',function(){
    tag = '';
    if($(this).attr('data-href') != 0){
        tag = $(this).attr('data-href');
    }
   $('#tag').val(tag);
   $('#search-button').click();
})

$(document).on('click','.review_val',function(){
    review = $(".review_val:checked").val();
    $('#review').val(review);
    $('#search-button').click();
})

$(document).on('keypress','.input-search',function(e){
    var key = e.which;
    if(key == 13)  // the enter key code
    {
        search = $('.input-search').val();
        $('#search').val(search);
        $('#search-button').click();
        return false;  
    }

})

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jobcfpuz/company2.peoplestechpark.com/core/resources/views/front/product/product.blade.php ENDPATH**/ ?>